/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileMonitorModule;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.math.Color;

public class RenderMonitorModule
extends AbstractTileRenderer<TileMonitorModule> {
    public RenderMonitorModule(TileEntityRendererDispatcher context) {
        super(context);
    }

    public void render(@Nonnull TileMonitorModule tile, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!((Boolean)tile.linked.getValue()).booleanValue()) {
            return;
        }
        long time = System.currentTimeMillis() % 1500L - 750L;
        if (time < 0L) {
            return;
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        Direction facing = tile.getFacing();
        stack.func_227860_a_();
        stack.func_227861_a_(0.5, 0.5, 0.5);
        this.rotateMatrix(stack, facing);
        stack.func_227861_a_(0.1, 0.3, -0.188125);
        StringTextComponent transfer = new StringTextComponent("_");
        int width = font.func_238414_a_((ITextProperties)transfer);
        float scale = 0.0215f / ((float)width / 8.0f);
        stack.func_227862_a_(-scale, -scale, -scale);
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        float textX = (float)(-width) / 2.0f;
        font.func_243247_a((ITextComponent)transfer, textX, 0.0f, Color.WHITE.color(), false, matrix4f, bufferIn, false, 0, combinedLightIn);
        stack.func_227865_b_();
    }

    private void rotateMatrix(MatrixStack stack, Direction dir) {
        switch (dir) {
            case EAST: {
                stack.func_227863_a_(new Quaternion(0.0f, -90.0f, 0.0f, true));
                break;
            }
            case SOUTH: {
                stack.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                break;
            }
            case WEST: {
                stack.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                break;
            }
        }
    }
}

