/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import nuclearscience.common.tile.TileNuclearBoiler;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.utilities.RenderingUtils;

public class RenderNuclearBoiler
extends AbstractTileRenderer<TileNuclearBoiler> {
    private static final float DELTA_Y = 0.225f;

    public RenderNuclearBoiler(TileEntityRendererDispatcher context) {
        super(context);
    }

    public void render(TileNuclearBoiler tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        matrix.func_227860_a_();
        Direction facing = tile.getFacing();
        IVertexBuilder builder = buffer.getBuffer(Atlases.func_228785_j_());
        PropertyFluidTank input = ((ComponentFluidHandlerMulti)tile.getComponent(IComponentType.FluidHandler)).getInputTanks()[0];
        if (!input.isEmpty()) {
            this.drawFluidInput(matrix, builder, input.getFluid(), facing, (float)input.getFluidAmount() / 5000.0f, light, overlay);
        }
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        PropertyFluidTank output = ((ComponentFluidHandlerMulti)tile.getComponent(IComponentType.FluidHandler)).getOutputTanks()[0];
        if (!output.isEmpty()) {
            this.drawFluidOutput(matrix, builder, output.getFluid(), facing, (float)output.getFluidAmount() / 5000.0f, light, overlay);
        }
        matrix.func_227865_b_();
    }

    private void drawFluidInput(MatrixStack stack, IVertexBuilder builder, FluidStack fluid, Direction facing, float height, int light, int overlay) {
        AxisAlignedBB box = null;
        float maxY = 0.225f * height + 0.5125f;
        box = facing == Direction.NORTH ? new AxisAlignedBB(0.54375, 0.5125, 0.3875, 0.70625, (double)maxY, 0.6125) : (facing == Direction.EAST ? new AxisAlignedBB(0.3875, 0.5125, 0.54375, 0.6125, (double)maxY, 0.70625) : (facing == Direction.SOUTH ? new AxisAlignedBB(0.29375, 0.5125, 0.3875, 0.45625, (double)maxY, 0.6125) : new AxisAlignedBB(0.3875, 0.5125, 0.29375, 0.6125, (double)maxY, 0.45625)));
        RenderingUtils.renderFluidBox((MatrixStack)stack, (Minecraft)this.minecraft(), (IVertexBuilder)builder, (AxisAlignedBB)box, (FluidStack)fluid, (int)light, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
    }

    private void drawFluidOutput(MatrixStack stack, IVertexBuilder builder, FluidStack fluid, Direction facing, float height, int light, int overlay) {
        AxisAlignedBB box = null;
        float maxY = 0.225f * height + 0.5125f;
        box = facing == Direction.NORTH ? new AxisAlignedBB(0.29375, 0.5125, 0.3875, 0.45625, (double)maxY, 0.6125) : (facing == Direction.EAST ? new AxisAlignedBB(0.3875, 0.5125, 0.29375, 0.6125, (double)maxY, 0.45625) : (facing == Direction.SOUTH ? new AxisAlignedBB(0.54375, 0.5125, 0.3875, 0.70625, (double)maxY, 0.6125) : new AxisAlignedBB(0.3875, 0.5125, 0.54375, 0.6125, (double)maxY, 0.70625)));
        RenderingUtils.renderFluidBox((MatrixStack)stack, (Minecraft)this.minecraft(), (IVertexBuilder)builder, (AxisAlignedBB)box, (FluidStack)fluid, (int)light, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
    }
}

