/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import nuclearscience.common.tile.TileRadioactiveProcessor;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.utilities.RenderingUtils;

public class RenderRadioactiveProcessor
extends AbstractTileRenderer<TileRadioactiveProcessor> {
    private static final float DELTA_Y = 0.25f;

    public RenderRadioactiveProcessor(TileEntityRendererDispatcher context) {
        super(context);
    }

    public void render(TileRadioactiveProcessor tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int overlay) {
        matrix.func_227860_a_();
        Direction facing = tile.getFacing();
        ComponentFluidHandlerMulti multi = (ComponentFluidHandlerMulti)tile.getComponent(IComponentType.FluidHandler);
        IVertexBuilder builder = buffer.getBuffer(Atlases.func_228785_j_());
        PropertyFluidTank input = multi.getInputTanks()[0];
        if (input.isEmpty()) {
            matrix.func_227865_b_();
            return;
        }
        AxisAlignedBB box = null;
        float maxY = 0.25f * ((float)input.getFluidAmount() / 5000.0f) + 0.4375f;
        switch (facing) {
            case NORTH: {
                box = new AxisAlignedBB(0.25, 0.4375, 0.03125, 0.75, (double)maxY, 0.0625);
                RenderingUtils.renderFluidBox((MatrixStack)matrix, (Minecraft)this.minecraft(), (IVertexBuilder)builder, (AxisAlignedBB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                break;
            }
            case SOUTH: {
                box = new AxisAlignedBB(0.25, 0.4375, 0.96875, 0.75, (double)maxY, 0.9375);
                RenderingUtils.renderFluidBox((MatrixStack)matrix, (Minecraft)this.minecraft(), (IVertexBuilder)builder, (AxisAlignedBB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                break;
            }
            case EAST: {
                box = new AxisAlignedBB(0.96875, 0.4375, 0.25, 0.9375, (double)maxY, 0.75);
                RenderingUtils.renderFluidBox((MatrixStack)matrix, (Minecraft)this.minecraft(), (IVertexBuilder)builder, (AxisAlignedBB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                break;
            }
            case WEST: {
                box = new AxisAlignedBB(0.03125, 0.4375, 0.25, 0.0625, (double)maxY, 0.75);
                RenderingUtils.renderFluidBox((MatrixStack)matrix, (Minecraft)this.minecraft(), (IVertexBuilder)builder, (AxisAlignedBB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                break;
            }
        }
        matrix.func_227865_b_();
    }
}

