/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import nuclearscience.client.screen.util.GenericInterfaceBoundScreen;
import nuclearscience.common.inventory.container.ContainerMonitorModule;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.fusion.TileFusionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileMonitorModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileFissionInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileFusionInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileMSInterface;
import nuclearscience.common.tile.reactor.moltensalt.TileFreezePlug;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;
import voltaic.prefab.screen.component.types.ScreenComponentCustomRender;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenMonitorModule
extends GenericInterfaceBoundScreen<ContainerMonitorModule> {
    private boolean hidden = false;
    private static final ITexture EMPTY_FUEL = NuclearIconTypes.FUEL_CELL_DARK;

    public ScreenMonitorModule(ContainerMonitorModule container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title, true, false);
        for (int i = 0; i < ((ContainerMonitorModule)this.func_212873_a_()).field_75151_b.size(); ++i) {
            ((SlotGeneric)((ContainerMonitorModule)this.func_212873_a_()).field_75151_b.get(i)).setActive(false);
        }
        this.addComponent((AbstractScreenComponent)new ScreenComponentCustomRender(0, 0, poseStack -> {
            if (this.hidden) {
                return;
            }
            TileMonitorModule tile = (TileMonitorModule)((ContainerMonitorModule)this.field_147002_h).getSafeHost();
            if (tile == null) {
                return;
            }
            GenericTileInterface.InterfaceType type = GenericTileInterface.InterfaceType.values()[(Integer)tile.interfaceType.getValue()];
            FontRenderer font = this.getFontRenderer();
            int guiWidth = (int)this.getGuiWidth();
            int guiHeight = (int)this.getGuiHeight();
            ScreenMonitorModule.func_238467_a_((MatrixStack)poseStack, (int)(guiWidth + 17), (int)(guiHeight + 17), (int)(guiWidth + 159), (int)(guiHeight + 149), (int)new Color(112, 112, 112, 255).color());
            if (!((Boolean)tile.linked.getValue()).booleanValue() || type == GenericTileInterface.InterfaceType.NONE || ((BlockPos)tile.interfaceLocation.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
                font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                return;
            }
            TileEntity blockEntity = tile.func_145831_w().func_175625_s((BlockPos)tile.interfaceLocation.getValue());
            switch (type) {
                case FISSION: {
                    if (!(blockEntity instanceof TileFissionInterface)) {
                        font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileFissionInterface fissionInterface = (TileFissionInterface)blockEntity;
                    if (fissionInterface.reactor == null || !fissionInterface.reactor.valid() || !(fissionInterface.reactor.getSafe() instanceof TileFissionReactorCore)) {
                        font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileFissionReactorCore fissionCore = (TileFissionReactorCore)((Object)((Object)fissionInterface.reactor.getSafe()));
                    Minecraft.func_71410_x().func_175599_af().func_175042_a(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.temperature", ChatFormatter.getChatDisplayShort((double)TileFissionReactorCore.getActualTemp((Double)fissionCore.temperature.getValue()), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS).func_240699_a_(TextFormatting.GOLD)), (float)(guiWidth + 20), (float)(guiHeight + 45), Color.TEXT_GRAY.color());
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.fuel", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 65), Color.TEXT_GRAY.color());
                    ComponentInventory inventory = (ComponentInventory)fissionCore.getComponent(IComponentType.Inventory);
                    List fuels = inventory.getItems().subList(0, 4);
                    int i = 0;
                    int empty = 0;
                    for (ItemStack item : fuels) {
                        if (item.func_190926_b()) {
                            RenderingUtils.bindTexture((ResourceLocation)EMPTY_FUEL.getLocation());
                            ScreenMonitorModule.func_238463_a_((MatrixStack)poseStack, (int)(guiWidth + 20 + i * 20 + 2), (int)(guiHeight + 75 + 2), (float)EMPTY_FUEL.textureU(), (float)EMPTY_FUEL.textureV(), (int)EMPTY_FUEL.textureWidth(), (int)EMPTY_FUEL.textureHeight(), (int)EMPTY_FUEL.imageWidth(), (int)EMPTY_FUEL.imageHeight());
                            ++empty;
                        } else {
                            Minecraft.func_71410_x().func_175599_af().func_175042_a(item, guiWidth + 20 + i * 20, guiHeight + 75);
                            Minecraft.func_71410_x().func_175599_af().func_175030_a(font, item, guiWidth + 20 + i * 20, guiHeight + 75);
                        }
                        ++i;
                    }
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.other", new Object[0]), (float)(guiWidth + 110), (float)(guiHeight + 65), Color.TEXT_GRAY.color());
                    ItemStack deuterium = inventory.func_70301_a(4);
                    if (deuterium.func_190926_b()) {
                        RenderingUtils.bindTexture((ResourceLocation)EMPTY_FUEL.getLocation());
                        ScreenMonitorModule.func_238463_a_((MatrixStack)poseStack, (int)(guiWidth + 110 + 2), (int)(guiHeight + 75 + 2), (float)EMPTY_FUEL.textureU(), (float)EMPTY_FUEL.textureV(), (int)EMPTY_FUEL.textureWidth(), (int)EMPTY_FUEL.textureHeight(), (int)EMPTY_FUEL.imageWidth(), (int)EMPTY_FUEL.imageHeight());
                    } else {
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(deuterium, guiWidth + 110, guiHeight + 75);
                        Minecraft.func_71410_x().func_175599_af().func_175030_a(font, deuterium, guiWidth + 110, guiHeight + 75);
                    }
                    ItemStack tritium = (ItemStack)inventory.getOutputContents().get(0);
                    if (tritium.func_190926_b()) {
                        RenderingUtils.bindTexture((ResourceLocation)EMPTY_FUEL.getLocation());
                        ScreenMonitorModule.func_238463_a_((MatrixStack)poseStack, (int)(guiWidth + 130 + 2), (int)(guiHeight + 75 + 2), (float)EMPTY_FUEL.textureU(), (float)EMPTY_FUEL.textureV(), (int)EMPTY_FUEL.textureWidth(), (int)EMPTY_FUEL.textureHeight(), (int)EMPTY_FUEL.imageWidth(), (int)EMPTY_FUEL.imageHeight());
                    } else {
                        Minecraft.func_71410_x().func_175599_af().func_175042_a(tritium, guiWidth + 130, guiHeight + 75);
                        Minecraft.func_71410_x().func_175599_af().func_175030_a(font, tritium, guiWidth + 130, guiHeight + 75);
                    }
                    IFormattableTextComponent status = NuclearTextUtils.gui("logisticsnetwork.statusgood", new Object[0]).func_240699_a_(TextFormatting.GREEN);
                    if (empty == 4) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusnofuel", new Object[0]).func_240699_a_(TextFormatting.YELLOW);
                    } else if ((Double)fissionCore.temperature.getValue() > 5611.0) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusoverheat", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD});
                    }
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.status", status), (float)(guiWidth + 20), (float)(guiHeight + 105), Color.TEXT_GRAY.color());
                    break;
                }
                case MS: {
                    if (!(blockEntity instanceof TileMSInterface)) {
                        font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileMSInterface msInterface = (TileMSInterface)blockEntity;
                    if (msInterface.reactor == null || !msInterface.reactor.valid() || !(msInterface.reactor.getSafe() instanceof TileMSReactorCore)) {
                        font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileMSReactorCore msCore = (TileMSReactorCore)((Object)((Object)msInterface.reactor.getSafe()));
                    Minecraft.func_71410_x().func_175599_af().func_175042_a(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.temperature", ChatFormatter.getChatDisplayShort((double)((Double)msCore.temperature.getValue()), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS).func_240699_a_(TextFormatting.GOLD)), (float)(guiWidth + 20), (float)(guiHeight + 45), Color.TEXT_GRAY.color());
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.fuel", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 65), Color.TEXT_GRAY.color());
                    font.func_243248_b(poseStack, (ITextComponent)VoltaicTextUtils.ratio((IFormattableTextComponent)ChatFormatter.getChatDisplayShort((double)((Double)msCore.currentFuel.getValue() / 1000.0), (IDisplayUnit)DisplayUnits.BUCKETS), (IFormattableTextComponent)ChatFormatter.getChatDisplayShort((double)1.0, (IDisplayUnit)DisplayUnits.BUCKETS)), (float)(guiWidth + 30), (float)(guiHeight + 75), Color.WHITE.color());
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.waste", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 90), Color.TEXT_GRAY.color());
                    font.func_243248_b(poseStack, (ITextComponent)VoltaicTextUtils.ratio((IFormattableTextComponent)ChatFormatter.getChatDisplayShort((double)((Double)msCore.currentWaste.getValue() / 1000.0), (IDisplayUnit)DisplayUnits.BUCKETS), (IFormattableTextComponent)ChatFormatter.getChatDisplayShort((double)1.0, (IDisplayUnit)DisplayUnits.BUCKETS)), (float)(guiWidth + 30), (float)(guiHeight + 100), Color.WHITE.color());
                    IFormattableTextComponent status = NuclearTextUtils.gui("logisticsnetwork.statusgood", new Object[0]).func_240699_a_(TextFormatting.GREEN);
                    if (!(msCore.clientPlugCache.getSafe() instanceof TileFreezePlug)) {
                        status = NuclearTextUtils.gui("msreactor.status.nofreezeplug", new Object[0]).func_240699_a_(TextFormatting.RED);
                    } else if (msCore.clientPlugCache.getSafe() instanceof TileFreezePlug && !((TileFreezePlug)((Object)((Object)msCore.clientPlugCache.getSafe()))).isFrozen()) {
                        status = NuclearTextUtils.gui("msreactor.warning.freezeoff", new Object[0]).func_240699_a_(TextFormatting.YELLOW);
                    } else if (((Boolean)msCore.wasteIsFull.getValue()).booleanValue()) {
                        status = NuclearTextUtils.gui("msreactor.status.wastefull", new Object[0]).func_240699_a_(TextFormatting.YELLOW);
                    } else if ((Double)msCore.temperature.getValue() > 1000.0) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusoverheat", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD});
                    }
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.status", status), (float)(guiWidth + 20), (float)(guiHeight + 115), Color.TEXT_GRAY.color());
                    break;
                }
                case FUSION: {
                    if (!(blockEntity instanceof TileFusionInterface)) {
                        font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileFusionInterface fusionInterface = (TileFusionInterface)blockEntity;
                    if (fusionInterface.reactor == null || !fusionInterface.reactor.valid() || !(fusionInterface.reactor.getSafe() instanceof TileFusionReactorCore)) {
                        font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileFusionReactorCore fusionCore = (TileFusionReactorCore)((Object)((Object)fusionInterface.reactor.getSafe()));
                    ComponentElectrodynamic electro = (ComponentElectrodynamic)fusionCore.getComponent(IComponentType.Electrodynamic);
                    Minecraft.func_71410_x().func_175599_af().func_175042_a(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.deuterium", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 45), Color.TEXT_GRAY.color());
                    font.func_243248_b(poseStack, (ITextComponent)VoltaicTextUtils.ratio((IFormattableTextComponent)new StringTextComponent(fusionCore.deuterium.getValue() + ""), (IFormattableTextComponent)new StringTextComponent(NuclearConstants.FUSIONREACTOR_MAXSTORAGE + "")), (float)(guiWidth + 30), (float)(guiHeight + 55), Color.WHITE.color());
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.tritium", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 70), Color.TEXT_GRAY.color());
                    font.func_243248_b(poseStack, (ITextComponent)VoltaicTextUtils.ratio((IFormattableTextComponent)new StringTextComponent(fusionCore.tritium.getValue() + ""), (IFormattableTextComponent)new StringTextComponent(NuclearConstants.FUSIONREACTOR_MAXSTORAGE + "")), (float)(guiWidth + 30), (float)(guiHeight + 80), Color.WHITE.color());
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.power", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 95), Color.TEXT_GRAY.color());
                    font.func_243248_b(poseStack, (ITextComponent)ChatFormatter.getChatDisplayShort((double)(Math.min(1.0, electro.getJoulesStored() / NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK) * 100.0), (IDisplayUnit)DisplayUnits.PERCENTAGE), (float)(guiWidth + 30), (float)(guiHeight + 105), Color.WHITE.color());
                    IFormattableTextComponent status = NuclearTextUtils.gui("logisticsnetwork.statusgood", new Object[0]).func_240699_a_(TextFormatting.GREEN);
                    if ((Integer)fusionCore.tritium.getValue() < 1 || (Integer)fusionCore.deuterium.getValue() < 1) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusnofuel", new Object[0]).func_240699_a_(TextFormatting.RED);
                    } else if (electro.getJoulesStored() < NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusnopower", new Object[0]).func_240699_a_(TextFormatting.YELLOW);
                    }
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.status", status), (float)(guiWidth + 20), (float)(guiHeight + 120), Color.TEXT_GRAY.color());
                    break;
                }
            }
        }));
    }

    @Override
    public void updateNonSelectorVisibility(boolean visible) {
        this.hidden = !visible;
    }
}

