/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import nuclearscience.common.entity.EntityParticle;
import nuclearscience.common.inventory.container.ContainerParticleInjector;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.accelerator.TileElectromagneticGateway;
import nuclearscience.common.tile.accelerator.TileParticleInjector;
import nuclearscience.compatibility.jei.utils.NuclearJeiTextures;
import nuclearscience.prefab.screen.component.NuclearArrows;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.utils.NuclearDisplayUnits;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.math.Color;

public class ScreenParticleInjector
extends GenericScreen<ContainerParticleInjector> {
    public ScreenParticleInjector(ContainerParticleInjector container, PlayerInventory playerInventory, ITextComponent title) {
        super((GenericContainer)container, playerInventory, title);
        this.field_147000_g += 10;
        this.field_238745_s_ += 10;
        this.addComponent((AbstractScreenComponent)new ScreenComponentGeneric((ITexture)NuclearArrows.PARTICLE_INJECTOR_ARROWS, 44, 24));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(this.field_238742_p_, this.field_238743_q_ + 20, 10, Color.TEXT_GRAY, (ITextComponent)NuclearTextUtils.gui("particleinjector.matter", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(this.field_238742_p_, this.field_238743_q_ + 56, 10, Color.TEXT_GRAY, (ITextComponent)NuclearTextUtils.gui("particleinjector.cells", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2).wattage(NuclearConstants.PARTICLEINJECTOR_USAGE_PER_PARTICLE));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, -25, 54).setOnPress(button -> {
            TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.field_147002_h).getSafeHost();
            if (injector == null) {
                return;
            }
            injector.usingGateway.setValue((Object)((Boolean)injector.usingGateway.getValue() == false ? 1 : 0));
        }).setIcon((ITexture)NuclearIconTypes.GATEWAY).onTooltip((poseStack, button, x, y) -> {
            ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
            TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.field_147002_h).getSafeHost();
            if (injector == null) {
                return;
            }
            list.add(NuclearTextUtils.tooltip("particleinjector.gatewaymode", new Object[0]).func_240699_a_(TextFormatting.DARK_GRAY).func_241878_f());
            if (((Boolean)injector.usingGateway.getValue()).booleanValue()) {
                list.add(NuclearTextUtils.tooltip("particleinjector.gatewayenabled", new Object[0]).func_240699_a_(TextFormatting.GREEN).func_241878_f());
            } else {
                list.add(NuclearTextUtils.tooltip("particleinjector.gatewaydisabled", new Object[0]).func_240699_a_(TextFormatting.RED).func_241878_f());
            }
            this.displayTooltips(poseStack, list, x, y);
        }));
        new WrapperInventoryIO((GenericScreen)this, -25, 28, 75, 82, 8, 72);
        this.addComponent((AbstractScreenComponent)new ScreenComponentGeneric((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR_RIGHT, this.field_146999_f - 1, 2).setIcon((ITexture)NuclearJeiTextures.PARTICLEACCELERATOR_DMATOM).onTooltip((poseStack, component, x, y) -> {
            ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
            TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.field_147002_h).getSafeHost();
            if (injector == null) {
                return;
            }
            EntityParticle one = injector.particles[0];
            float oneSpeed = 0.0f;
            if (one != null && one.func_70089_S() && one.func_70089_S()) {
                oneSpeed = one.speed;
            }
            list.add(NuclearTextUtils.tooltip("particleinjector.particle1speed", ChatFormatter.getChatDisplayShort((double)TileElectromagneticGateway.getLightSpeedPerc(oneSpeed), (IDisplayUnit)DisplayUnits.PERCENTAGE).func_240702_b_(" ").func_230529_a_((ITextComponent)NuclearDisplayUnits.SPEEDOFLIGHT.getSymbol()).func_240699_a_(TextFormatting.GRAY)).func_240699_a_(TextFormatting.DARK_GRAY).func_241878_f());
            EntityParticle two = injector.particles[1];
            float twoSpeed = 0.0f;
            if (two != null && two.func_70089_S() && two.func_70089_S()) {
                twoSpeed = two.speed;
            }
            list.add(NuclearTextUtils.tooltip("particleinjector.particle2speed", ChatFormatter.getChatDisplayShort((double)TileElectromagneticGateway.getLightSpeedPerc(twoSpeed), (IDisplayUnit)DisplayUnits.PERCENTAGE).func_240702_b_(" ").func_230529_a_((ITextComponent)NuclearDisplayUnits.SPEEDOFLIGHT.getSymbol()).func_240699_a_(TextFormatting.GRAY)).func_240699_a_(TextFormatting.DARK_GRAY).func_241878_f());
            this.func_238654_b_(poseStack, list, x, y);
        }));
    }

    private List<? extends IReorderingProcessor> getElectricInformation() {
        ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
        TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.field_147002_h).getSafeHost();
        if (injector == null) {
            return list;
        }
        ComponentElectrodynamic el = (ComponentElectrodynamic)injector.getComponent(IComponentType.Electrodynamic);
        list.add(NuclearTextUtils.tooltip("particleinjector.charge", ChatFormatter.getChatDisplayShort((double)el.getJoulesStored(), (IDisplayUnit)DisplayUnits.JOULES).func_240699_a_(TextFormatting.GRAY), ChatFormatter.getChatDisplayShort((double)NuclearConstants.PARTICLEINJECTOR_USAGE_PER_PARTICLE, (IDisplayUnit)DisplayUnits.JOULES).func_240699_a_(TextFormatting.GRAY)).func_240699_a_(TextFormatting.DARK_GRAY).func_241878_f());
        list.add(ElectroTextUtils.gui((String)"machine.voltage", (Object[])new Object[]{ChatFormatter.getChatDisplayShort((double)el.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY).func_241878_f());
        return list;
    }
}

