/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.common.inventory.container.ContainerQuantumTunnel;
import nuclearscience.common.tile.TileQuantumTunnel;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperEditFrequency;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperIOEditor;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperNewFrequency;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperQuantumTunnelFrequencies;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.object.TransferPack;

public class ScreenQuantumTunnel
extends GenericScreen<ContainerQuantumTunnel> {
    public WrapperQuantumTunnelFrequencies frequencyWrapper;
    public WrapperIOEditor ioWrapper;
    public WrapperNewFrequency newFrequencyWrapper;
    public WrapperEditFrequency editFrequencyWrapper;
    public ScreenComponentVerticalSlider slider;

    public ScreenQuantumTunnel(ContainerQuantumTunnel container, PlayerInventory playerInventory, ITextComponent title) {
        super((GenericContainer)container, playerInventory, title);
        this.field_147000_g += 35;
        this.frequencyWrapper = new WrapperQuantumTunnelFrequencies(this, 0, 0);
        this.slider = new ScreenComponentVerticalSlider(5, 64, 125).setClickConsumer(this.frequencyWrapper.getSliderClickedConsumer()).setDragConsumer(this.frequencyWrapper.getSliderDraggedConsumer());
        this.addComponent((AbstractScreenComponent)this.slider);
        this.ioWrapper = new WrapperIOEditor(this, -25, 28, 80, 28, 8, 23);
        this.newFrequencyWrapper = new WrapperNewFrequency(this, -25, 2, 0, 15);
        this.editFrequencyWrapper = new WrapperEditFrequency(this, 0, 10);
        this.addComponent((AbstractScreenComponent)new ScreenComponentGuiTab((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, (ITexture)NuclearIconTypes.BUFFER, () -> {
            TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)this.func_212873_a_()).getSafeHost();
            if (tile == null) {
                return Collections.emptyList();
            }
            TunnelFrequencyBuffer buffer = tile.clientBuffer;
            ArrayList<IReorderingProcessor> info = new ArrayList<IReorderingProcessor>();
            info.add(NuclearTextUtils.tooltip("quantumtunnel.buffer", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.YELLOW}).func_241878_f());
            ItemStack item = buffer.getBufferedItem();
            info.add(new TranslationTextComponent(item.func_77977_a()).func_241878_f());
            info.add(new StringTextComponent(" " + item.func_190916_E()).func_240699_a_(TextFormatting.GRAY).func_241878_f());
            FluidStack fluid = buffer.getBufferedFluid();
            info.add(new TranslationTextComponent(fluid.getTranslationKey()).func_241878_f());
            info.add(new StringTextComponent(" ").func_230529_a_((ITextComponent)ChatFormatter.formatFluidMilibuckets((double)fluid.getAmount()).func_240699_a_(TextFormatting.GRAY)).func_241878_f());
            TransferPack energy = buffer.getBufferedEnergy();
            info.add(ChatFormatter.getChatDisplayShort((double)energy.getJoules(), (IDisplayUnit)DisplayUnits.JOULES).func_241878_f());
            info.add(new StringTextComponent(" ").func_230529_a_((ITextComponent)ChatFormatter.getChatDisplayShort((double)energy.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).func_240699_a_(TextFormatting.GRAY)).func_241878_f());
            return info;
        }, -25, 54));
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.frequencyWrapper.tick();
    }

    protected void initializeComponents() {
        super.initializeComponents();
        this.playerInvLabel.setVisible(false);
    }

    public boolean func_231043_a_(double pMouseX, double pMouseY, double pDelta) {
        if (this.frequencyWrapper != null) {
            if (pDelta > 0.0) {
                this.frequencyWrapper.handleMouseScroll(-1);
            } else if (pDelta < 0.0) {
                this.frequencyWrapper.handleMouseScroll(1);
            }
        }
        return super.func_231043_a_(pMouseX, pMouseY, pDelta);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.slider != null && this.slider.isVisible()) {
            this.slider.func_231044_a_(mouseX, mouseY, button);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.slider != null && this.slider.isVisible()) {
            this.slider.func_231048_c_(mouseX, mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231046_a_(int pKeyCode, int pScanCode, int pModifiers) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)pKeyCode, (int)pScanCode);
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey) && this.newFrequencyWrapper.nameEditBox.func_230999_j_()) {
            return false;
        }
        return super.func_231046_a_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.slider.isVisible()) {
            return this.slider.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }
}

