/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import nuclearscience.common.inventory.container.ContainerRadioisotopeGenerator;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.reloadlistener.RadioactiveItemRegister;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentMultiLabel;
import voltaic.prefab.screen.component.types.ScreenComponentProgress;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.object.TransferPack;

public class ScreenRadioisotopeGenerator
extends GenericScreen<ContainerRadioisotopeGenerator> {
    public ScreenRadioisotopeGenerator(ContainerRadioisotopeGenerator container, PlayerInventory playerInventory, ITextComponent title) {
        super((GenericContainer)container, playerInventory, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentProgress(ScreenComponentProgress.ProgressBars.COUNTDOWN_FLAME, () -> {
            ItemStack in = container.func_75139_a(0).func_75211_c();
            RadioactiveObject rad = RadioactiveItemRegister.getValue((Item)in.func_77973_b());
            double currentOutput = (double)in.func_190916_E() * NuclearConstants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.amount();
            if (currentOutput > 0.0) {
                return 1.0;
            }
            return 0.0;
        }, 25, 24));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getEnergyInformation, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentMultiLabel(0, 0, poseStack -> {
            ItemStack in = ((ContainerRadioisotopeGenerator)this.field_147002_h).func_75139_a(0).func_75211_c();
            RadioactiveObject rad = RadioactiveItemRegister.getValue((Item)in.func_77973_b());
            double currentOutput = (double)in.func_190916_E() * NuclearConstants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.amount();
            TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE), (double)NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE);
            this.field_230712_o_.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("machine.current", ChatFormatter.getChatDisplayShort((double)transfer.getAmps(), (IDisplayUnit)DisplayUnits.AMPERE)), (float)(this.field_238744_r_ + 60), (float)(this.field_238745_s_ - 48), Color.TEXT_GRAY.color());
            this.field_230712_o_.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("machine.output", ChatFormatter.getChatDisplayShort((double)transfer.getWatts(), (IDisplayUnit)DisplayUnits.WATT)), (float)(this.field_238744_r_ + 60), (float)(this.field_238745_s_ - 35), Color.TEXT_GRAY.color());
            this.field_230712_o_.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)transfer.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE)), (float)(this.field_238744_r_ + 60), (float)(this.field_238745_s_ - 22), Color.TEXT_GRAY.color());
        }));
        new WrapperInventoryIO((GenericScreen)this, -25, 28, 75, 82, 8, 72);
    }

    private List<? extends IReorderingProcessor> getEnergyInformation() {
        ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
        ItemStack in = ((ContainerRadioisotopeGenerator)this.field_147002_h).func_75139_a(0).func_75211_c();
        RadioactiveObject rad = RadioactiveItemRegister.getValue((Item)in.func_77973_b());
        double currentOutput = (double)in.func_190916_E() * NuclearConstants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.amount();
        TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE), (double)NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE);
        list.add(NuclearTextUtils.gui("machine.current", ChatFormatter.getChatDisplayShort((double)transfer.getAmps(), (IDisplayUnit)DisplayUnits.AMPERE)).func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.DARK_GRAY).func_241878_f());
        list.add(NuclearTextUtils.gui("machine.output", ChatFormatter.getChatDisplayShort((double)transfer.getWatts(), (IDisplayUnit)DisplayUnits.WATT).func_240699_a_(TextFormatting.GRAY)).func_240699_a_(TextFormatting.DARK_GRAY).func_241878_f());
        list.add(NuclearTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)transfer.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).func_240699_a_(TextFormatting.GRAY)).func_240699_a_(TextFormatting.DARK_GRAY).func_241878_f());
        return list;
    }
}

