/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import nuclearscience.common.inventory.container.ContainerTeleporter;
import nuclearscience.common.item.ItemFrequencyCard;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.TileTeleporter;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.math.Color;

public class ScreenTeleporter
extends GenericScreen<ContainerTeleporter> {
    private final ScreenComponentEditBox xBox;
    private final ScreenComponentEditBox yBox;
    private final ScreenComponentEditBox zBox;
    private boolean needsUpdate = true;

    public ScreenTeleporter(ContainerTeleporter container, PlayerInventory inv, ITextComponent title) {
        super((GenericContainer)container, inv, title);
        this.field_147000_g += 50;
        this.field_238745_s_ += 50;
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 20, 10, Color.TEXT_GRAY, () -> {
            TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.func_212873_a_()).getSafeHost();
            if (tile == null) {
                return new StringTextComponent("");
            }
            RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)((ResourceLocation)tile.dimension.getValue()));
            if (ElectroTextUtils.dimensionExists((RegistryKey)dimension)) {
                return ElectroTextUtils.dimension((RegistryKey)dimension, (Object[])new Object[0]);
            }
            return new StringTextComponent(dimension.func_240901_a_().func_110623_a());
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 33, 10, Color.TEXT_GRAY, (ITextComponent)NuclearTextUtils.gui("teleporter.x", new Object[0])));
        this.xBox = new ScreenComponentEditBox(40, 30, 60, 13, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(9).setResponder(this::updateX).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.xBox);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 49, 10, Color.TEXT_GRAY, (ITextComponent)NuclearTextUtils.gui("teleporter.y", new Object[0])));
        this.yBox = new ScreenComponentEditBox(40, 46, 60, 13, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(9).setResponder(this::updateY).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.yBox);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 65, 10, Color.TEXT_GRAY, (ITextComponent)NuclearTextUtils.gui("teleporter.z", new Object[0])));
        this.zBox = new ScreenComponentEditBox(40, 62, 60, 13, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(9).setResponder(this::updateZ).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.zBox);
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(50, 78, 100, 20).setOnPress(button -> {
            TileTeleporter tile = (TileTeleporter)container.getSafeHost();
            if (tile == null) {
                return;
            }
            ItemStack input = ((ComponentInventory)tile.getComponent(IComponentType.Inventory)).func_70301_a(0);
            if (input.func_190926_b() || !input.func_77942_o() || input.func_77978_p().func_74764_b("loc")) {
                return;
            }
            tile.destination.setValue((Object)ItemFrequencyCard.readBlockPos(input));
            if (input.func_77978_p().func_74764_b("dimension")) {
                tile.dimension.setValue(ItemFrequencyCard.readDimension(input));
            }
        }).setLabel(NuclearTextUtils.gui("teleporter.import", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(30, 100, 120, 20).setOnPress(button -> {
            TileTeleporter tile = (TileTeleporter)container.getSafeHost();
            if (tile == null) {
                return;
            }
            tile.destination.setValue((Object)tile.func_174877_v());
            tile.dimension.setValue((Object)World.field_234918_g_.func_240901_a_());
            this.xBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.field_147002_h).getSafeHost()).destination.getValue()).func_177958_n());
            this.yBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.field_147002_h).getSafeHost()).destination.getValue()).func_177956_o());
            this.zBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.field_147002_h).getSafeHost()).destination.getValue()).func_177952_p());
        }).setLabel(NuclearTextUtils.gui("teleporter.reset", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(-25, 2).wattage(NuclearConstants.TELEPORTER_USAGE_PER_TELEPORT / 20.0));
        this.xBox.setFocus(false);
        this.yBox.setFocus(false);
        this.zBox.setFocus(false);
    }

    private void updateX(String val) {
        this.xBox.setFocus(true);
        this.yBox.setFocus(false);
        this.zBox.setFocus(false);
        this.handleX(val);
    }

    private void updateY(String val) {
        this.xBox.setFocus(false);
        this.yBox.setFocus(true);
        this.zBox.setFocus(false);
        this.handleY(val);
    }

    private void updateZ(String val) {
        this.xBox.setFocus(false);
        this.yBox.setFocus(false);
        this.zBox.setFocus(true);
        this.handleZ(val);
    }

    private void handleX(String freq) {
        if (freq.isEmpty()) {
            return;
        }
        Integer x = 0;
        try {
            x = Integer.parseInt(this.xBox.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.field_147002_h).getSafeHost();
        if (tile == null) {
            return;
        }
        BlockPos dest = (BlockPos)tile.destination.getValue();
        tile.destination.setValue((Object)new BlockPos(x.intValue(), dest.func_177956_o(), dest.func_177952_p()));
    }

    private void handleY(String out) {
        if (out.isEmpty()) {
            return;
        }
        Integer y = 0;
        try {
            y = Integer.parseInt(this.yBox.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.field_147002_h).getSafeHost();
        if (tile == null) {
            return;
        }
        BlockPos dest = (BlockPos)tile.destination.getValue();
        tile.destination.setValue((Object)new BlockPos(dest.func_177958_n(), y.intValue(), dest.func_177952_p()));
    }

    private void handleZ(String out) {
        if (out.isEmpty()) {
            return;
        }
        Integer z = 0;
        try {
            z = Integer.parseInt(this.zBox.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.field_147002_h).getSafeHost();
        if (tile == null) {
            return;
        }
        BlockPos dest = (BlockPos)tile.destination.getValue();
        tile.destination.setValue((Object)new BlockPos(dest.func_177958_n(), dest.func_177956_o(), z.intValue()));
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        if (this.needsUpdate && ((ContainerTeleporter)this.field_147002_h).getSafeHost() != null) {
            this.needsUpdate = false;
            this.xBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.field_147002_h).getSafeHost()).destination.getValue()).func_177958_n());
            this.yBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.field_147002_h).getSafeHost()).destination.getValue()).func_177956_o());
            this.zBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.field_147002_h).getSafeHost()).destination.getValue()).func_177952_p());
        }
    }
}

