/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import nuclearscience.client.screen.util.GenericInterfaceBoundScreen;
import nuclearscience.common.inventory.container.ContainerThermometerModule;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileThermometerModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileFissionInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileMSInterface;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentCustomRender;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenThermometerModule
extends GenericInterfaceBoundScreen<ContainerThermometerModule> {
    public ScreenComponentButton<?> modeButton;
    public ScreenComponentButton<?> invertButton;
    public ScreenComponentEditBox targetTempBox;
    private boolean hidden = false;
    private boolean needsUpdate = true;

    public ScreenThermometerModule(ContainerThermometerModule container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title, true, false);
        for (int i = 0; i < ((ContainerThermometerModule)this.func_212873_a_()).field_75151_b.size(); ++i) {
            ((SlotGeneric)((ContainerThermometerModule)this.func_212873_a_()).field_75151_b.get(i)).setActive(false);
        }
        this.addComponent((AbstractScreenComponent)new ScreenComponentCustomRender(0, 0, poseStack -> {
            if (this.hidden) {
                return;
            }
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.field_147002_h).getSafeHost();
            if (tile == null) {
                this.modeButton.setVisible(false);
                this.invertButton.setVisible(false);
                this.targetTempBox.setVisible(false);
                return;
            }
            GenericTileInterface.InterfaceType type = GenericTileInterface.InterfaceType.values()[(Integer)tile.interfaceType.getValue()];
            FontRenderer font = this.getFontRenderer();
            int guiWidth = (int)this.getGuiWidth();
            int guiHeight = (int)this.getGuiHeight();
            ScreenThermometerModule.func_238467_a_((MatrixStack)poseStack, (int)(guiWidth + 17), (int)(guiHeight + 17), (int)(guiWidth + 159), (int)(guiHeight + 149), (int)new Color(112, 112, 112, 255).color());
            if (!((Boolean)tile.linked.getValue()).booleanValue() || type == GenericTileInterface.InterfaceType.NONE || ((BlockPos)tile.interfaceLocation.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
                font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                this.modeButton.setVisible(false);
                this.invertButton.setVisible(false);
                this.targetTempBox.setVisible(false);
                return;
            }
            TileEntity blockEntity = tile.func_145831_w().func_175625_s((BlockPos)tile.interfaceLocation.getValue());
            double currTemp = 0.0;
            switch (type) {
                case FISSION: {
                    if (!(blockEntity instanceof TileFissionInterface)) {
                        font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        this.modeButton.setVisible(false);
                        this.invertButton.setVisible(false);
                        this.targetTempBox.setVisible(false);
                        return;
                    }
                    TileFissionInterface fissionInterface = (TileFissionInterface)blockEntity;
                    if (fissionInterface.reactor == null || !fissionInterface.reactor.valid() || !(fissionInterface.reactor.getSafe() instanceof TileFissionReactorCore)) {
                        font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        this.modeButton.setVisible(false);
                        this.invertButton.setVisible(false);
                        this.targetTempBox.setVisible(false);
                        return;
                    }
                    TileFissionReactorCore fissionCore = (TileFissionReactorCore)((Object)((Object)fissionInterface.reactor.getSafe()));
                    currTemp = TileFissionReactorCore.getActualTemp((Double)fissionCore.temperature.getValue());
                    break;
                }
                case MS: {
                    if (!(blockEntity instanceof TileMSInterface)) {
                        font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        this.modeButton.setVisible(false);
                        this.invertButton.setVisible(false);
                        this.targetTempBox.setVisible(false);
                        return;
                    }
                    TileMSInterface msInterface = (TileMSInterface)blockEntity;
                    if (msInterface.reactor == null || !msInterface.reactor.valid() || !(msInterface.reactor.getSafe() instanceof TileMSReactorCore)) {
                        font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        this.modeButton.setVisible(false);
                        this.invertButton.setVisible(false);
                        this.targetTempBox.setVisible(false);
                        return;
                    }
                    TileMSReactorCore msCore = (TileMSReactorCore)((Object)((Object)msInterface.reactor.getSafe()));
                    currTemp = (Double)msCore.temperature.getValue();
                    break;
                }
                default: {
                    font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                    this.modeButton.setVisible(false);
                    this.invertButton.setVisible(false);
                    this.targetTempBox.setVisible(false);
                    return;
                }
            }
            this.modeButton.setVisible(true);
            this.invertButton.setVisible(true);
            this.targetTempBox.setVisible(true);
            Minecraft.func_71410_x().func_175599_af().func_175042_a(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
            font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.temperature", ChatFormatter.getChatDisplayShort((double)currTemp, (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS).func_240699_a_(TextFormatting.GOLD)), (float)(guiWidth + 20), (float)(guiHeight + 45), Color.TEXT_GRAY.color());
            IFormattableTextComponent text = NuclearTextUtils.gui("logisticsnetwork.outputmode", new Object[0]);
            int width = font.func_238414_a_((ITextProperties)text);
            int maxWidth = 68;
            int offset = (maxWidth - width) / 2;
            font.func_243248_b(poseStack, (ITextComponent)text, (float)(guiWidth + 20 + offset), (float)(guiHeight + 60), Color.TEXT_GRAY.color());
            text = NuclearTextUtils.gui("logisticsnetwork.signalmode", new Object[0]);
            width = font.func_238414_a_((ITextProperties)text);
            offset = (maxWidth - width) / 2;
            font.func_243248_b(poseStack, (ITextComponent)text, (float)(guiWidth + 20 + offset + maxWidth), (float)(guiHeight + 60), Color.TEXT_GRAY.color());
            font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.targettemp", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 100), Color.TEXT_GRAY.color());
            font.func_243248_b(poseStack, (ITextComponent)DisplayUnits.TEMPERATURE_CELCIUS.getSymbol().func_230532_e_().func_240699_a_(TextFormatting.WHITE), (float)(guiWidth + 20 + 120 + 2), (float)(guiHeight + 113), Color.TEXT_GRAY.color());
            font.func_243248_b(poseStack, (ITextComponent)NuclearTextUtils.gui("logisticsnetwork.signalstrength", new StringTextComponent("" + tile.redstoneSignal.getValue()).func_240699_a_(TextFormatting.WHITE)), (float)(guiWidth + 20), (float)(guiHeight + 135), Color.TEXT_GRAY.color());
        }));
        this.modeButton = new ScreenComponentButton(20, 70, 68, 20).setLabel(() -> {
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.field_147002_h).getSafeHost();
            if (tile == null) {
                return new StringTextComponent("");
            }
            switch (TileThermometerModule.Mode.values()[(Integer)tile.mode.getValue()]) {
                case BUILD_UP: {
                    return NuclearTextUtils.gui("logisticsnetwork.modebuildup", new Object[0]);
                }
                case CONSTANT: {
                    return NuclearTextUtils.gui("logisticsnetwork.modeconstant", new Object[0]);
                }
            }
            return new StringTextComponent("");
        }).setOnPress(button -> {
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.field_147002_h).getSafeHost();
            if (tile == null) {
                return;
            }
            int currMode = (Integer)tile.mode.getValue();
            currMode = currMode >= TileThermometerModule.Mode.values().length - 1 ? 0 : ++currMode;
            tile.mode.setValue((Object)currMode);
        });
        this.addComponent((AbstractScreenComponent)this.modeButton);
        this.invertButton = new ScreenComponentButton(88, 70, 68, 20).setLabel(() -> {
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.field_147002_h).getSafeHost();
            if (tile == null) {
                return new StringTextComponent("");
            }
            return (Boolean)tile.inverted.getValue() != false ? NuclearTextUtils.gui("logisticsnetwork.signalinverted", new Object[0]) : NuclearTextUtils.gui("logisticsnetwork.signalnormal", new Object[0]);
        }).setOnPress(button -> {
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.field_147002_h).getSafeHost();
            if (tile == null) {
                return;
            }
            tile.inverted.setValue((Object)((Boolean)tile.inverted.getValue() == false ? 1 : 0));
        });
        this.addComponent((AbstractScreenComponent)this.invertButton);
        this.targetTempBox = new ScreenComponentEditBox(20, 110, 120, 15, this.getFontRenderer()).setFilter(ScreenComponentEditBox.POSITIVE_DECIMAL).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(20).setResponder(val -> {
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.field_147002_h).getSafeHost();
            if (tile == null) {
                return;
            }
            double temp = 0.0;
            try {
                temp = Double.parseDouble(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (temp < 0.0) {
                temp = 0.0;
            }
            tile.targetTemperature.setValue((Object)temp);
        });
        this.addEditBox(this.targetTempBox);
    }

    @Override
    public void updateNonSelectorVisibility(boolean visible) {
        this.modeButton.setVisible(visible);
        this.invertButton.setVisible(visible);
        this.hidden = !visible;
        this.targetTempBox.setVisible(visible);
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        if (this.needsUpdate && ((ContainerThermometerModule)this.func_212873_a_()).getSafeHost() instanceof TileThermometerModule) {
            this.targetTempBox.setValue(((TileThermometerModule)((ContainerThermometerModule)this.func_212873_a_()).getSafeHost()).targetTemperature.getValue() + "");
            this.needsUpdate = false;
        }
    }
}

