/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import nuclearscience.common.block.subtype.SubtypeIrradiatedBlock;
import nuclearscience.registers.NuclearScienceBlocks;
import voltaic.api.radiation.util.IRadiationManager;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class BlockIrradiated
extends Block {
    public final SubtypeIrradiatedBlock subtype;

    public BlockIrradiated(SubtypeIrradiatedBlock subtype) {
        super(subtype.properties);
        this.subtype = subtype;
    }

    public void func_225542_b_(BlockState state, ServerWorld level, BlockPos pos, Random random) {
        IRadiationManager manager = (IRadiationManager)level.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER).orElse((Object)CapabilityUtils.EMPTY_MANAGER);
        if (manager == CapabilityUtils.EMPTY_MANAGER) {
            return;
        }
        int radius = manager.getReachOfSource((World)level, pos);
        if (radius <= 0) {
            return;
        }
        BlockState other = level.func_180495_p(pos);
        pos = pos.func_177982_a(BlockIrradiated.randomInt(-radius, radius, level.field_73012_v), BlockIrradiated.randomInt(-radius, radius, level.field_73012_v), BlockIrradiated.randomInt(-radius, radius, level.field_73012_v));
        if (BlockIrradiated.isValidPlacement(other)) {
            level.func_175656_a(pos, BlockIrradiated.getIrradiatedBlockstate(other));
        }
    }

    public static boolean isValidPlacement(BlockState state) {
        return state.func_235714_a_((ITag)Tags.Blocks.DIRT) || state.func_203425_a(Blocks.field_196658_i) || state.func_235714_a_((ITag)BlockTags.field_200031_h);
    }

    public static BlockState getIrradiatedBlockstate(BlockState state) {
        if (state.func_235714_a_((ITag)Tags.Blocks.DIRT)) {
            return ((BlockIrradiated)NuclearScienceBlocks.BLOCKS_IRRADIATED.getValue((Object)SubtypeIrradiatedBlock.soil)).func_176223_P();
        }
        if (state.func_203425_a(Blocks.field_196658_i)) {
            return ((BlockIrradiated)NuclearScienceBlocks.BLOCKS_IRRADIATED.getValue((Object)SubtypeIrradiatedBlock.grass)).func_176223_P();
        }
        if (state.func_235714_a_((ITag)BlockTags.field_200031_h)) {
            return ((BlockIrradiated)NuclearScienceBlocks.BLOCKS_IRRADIATED.getValue((Object)SubtypeIrradiatedBlock.petrifiedwood)).func_176223_P();
        }
        return state;
    }

    private static int randomInt(int min, int max, Random random) {
        return min + (int)(random.nextDouble() * (double)(max - min + 1));
    }
}

