/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.entity;

import com.mojang.serialization.DynamicOps;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import nuclearscience.common.block.states.NuclearScienceBlockStates;
import nuclearscience.common.block.states.facing.FacingDirection;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.accelerator.TileElectromagneticGateway;
import nuclearscience.common.tile.accelerator.TileParticleInjector;
import nuclearscience.prefab.sound.SoundBarrierMethods;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceEntities;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.Location;

public class EntityParticle
extends Entity {
    private static final DataParameter<Direction> DIRECTION = EntityDataManager.func_187226_a(EntityParticle.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(EntityParticle.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TICKS_ALIVE = EntityDataManager.func_187226_a(EntityParticle.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> SOURCE = EntityDataManager.func_187226_a(EntityParticle.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> PASSED_THROUGH_GATEWAY = EntityDataManager.func_187226_a(EntityParticle.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PASSED_THROUGH_SWITCH = EntityDataManager.func_187226_a(EntityParticle.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Direction> SWITCH_DIRECTION = EntityDataManager.func_187226_a(EntityParticle.class, (IDataSerializer)DataSerializers.field_187202_l);
    public static final float STARTING_SPEED = 0.02f;
    public static final float STRAIGHT_SPEED_INCREMENT = 0.0033333332f;
    public static final float TURN_SPEED_PENALTY = 0.9f;
    public static final float INVERT_SPEED_INCREMENT = -0.02f;
    public static final float MAX_SPEED = 2.0f;
    public static final float MIN_COLLISION_SPEED = 1.0f;
    private Direction facingDirection = Direction.UP;
    private Direction switchDirection = Direction.UP;
    public float speed = 0.02f;
    public BlockPos source = BlockEntityUtils.OUT_OF_REACH;
    public boolean passedThroughGate = false;
    private int ticksAlive = 0;
    private boolean passedThroughSwitch = false;
    private boolean firstTick = true;

    public EntityParticle(EntityType<?> entityTypeIn, World worldIn) {
        super((EntityType)NuclearScienceEntities.ENTITY_PARTICLE.get(), worldIn);
    }

    public EntityParticle(Direction direction, World worldIn, Location startPos, BlockPos ownerPos) {
        this((EntityType)NuclearScienceEntities.ENTITY_PARTICLE.get(), worldIn);
        this.func_70107_b(startPos.x(), startPos.y(), startPos.z());
        this.facingDirection = direction;
        this.field_70158_ak = true;
        this.source = ownerPos;
        if (worldIn.field_72995_K) {
            EntityParticle.func_184227_b((double)4.0);
        }
    }

    protected void func_70088_a() {
        if (this.facingDirection == null) {
            this.facingDirection = Direction.UP;
        }
        if (this.source == null) {
            this.source = BlockEntityUtils.OUT_OF_REACH;
        }
        if (this.switchDirection == null) {
            this.switchDirection = Direction.UP;
        }
        this.field_70180_af.func_187214_a(DIRECTION, (Object)this.facingDirection);
        this.field_70180_af.func_187214_a(SPEED, (Object)Float.valueOf(this.speed));
        this.field_70180_af.func_187214_a(TICKS_ALIVE, (Object)this.ticksAlive);
        this.field_70180_af.func_187214_a(SOURCE, (Object)this.source);
        this.field_70180_af.func_187214_a(PASSED_THROUGH_GATEWAY, (Object)this.passedThroughGate);
        this.field_70180_af.func_187214_a(PASSED_THROUGH_SWITCH, (Object)this.passedThroughSwitch);
        this.field_70180_af.func_187214_a(SWITCH_DIRECTION, (Object)this.switchDirection);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70071_h_() {
        boolean isServerside;
        boolean isClientside = this.field_70170_p.func_201670_d();
        boolean bl = isServerside = !isClientside;
        if (isServerside) {
            if (this.facingDirection == null) {
                this.facingDirection = Direction.UP;
            }
            this.field_70180_af.func_187227_b(DIRECTION, (Object)this.facingDirection);
            this.field_70180_af.func_187227_b(SPEED, (Object)Float.valueOf(this.speed));
            this.field_70180_af.func_187227_b(TICKS_ALIVE, (Object)this.ticksAlive);
            this.field_70180_af.func_187227_b(SOURCE, (Object)this.source);
            this.field_70180_af.func_187227_b(PASSED_THROUGH_GATEWAY, (Object)this.passedThroughGate);
            this.field_70180_af.func_187227_b(PASSED_THROUGH_SWITCH, (Object)this.passedThroughSwitch);
            this.field_70180_af.func_187227_b(SWITCH_DIRECTION, (Object)this.switchDirection);
            RadiationSystem.addRadiationSource((World)this.field_70170_p, (SimpleRadiationSource)new SimpleRadiationSource(1000.0, 1.0, 2, true, 0, this.func_233580_cy_(), false, false));
        } else {
            this.facingDirection = (Direction)this.field_70180_af.func_187225_a(DIRECTION);
            this.speed = ((Float)this.field_70180_af.func_187225_a(SPEED)).floatValue();
            this.ticksAlive = (Integer)this.field_70180_af.func_187225_a(TICKS_ALIVE);
            this.source = (BlockPos)this.field_70180_af.func_187225_a(SOURCE);
            this.passedThroughGate = (Boolean)this.field_70180_af.func_187225_a(PASSED_THROUGH_GATEWAY);
            this.passedThroughSwitch = (Boolean)this.field_70180_af.func_187225_a(PASSED_THROUGH_SWITCH);
            this.switchDirection = (Direction)this.field_70180_af.func_187225_a(SWITCH_DIRECTION);
        }
        if (isServerside) {
            ++this.ticksAlive;
        }
        if (this.ticksAlive > NuclearConstants.PARTICLE_SURVIVAL_TICKS) {
            if (!isServerside) return;
            this.func_241204_bJ_();
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.speed, Explosion.Mode.BREAK);
            return;
        }
        if (this.facingDirection == null) return;
        if (this.facingDirection == Direction.UP) {
            return;
        }
        TileEntity blockEntity = this.field_70170_p.func_175625_s(this.source);
        if (!(blockEntity instanceof TileParticleInjector)) {
            if (!isServerside) return;
            this.remove(false);
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.speed, Explosion.Mode.BREAK);
            return;
        }
        TileParticleInjector injector = (TileParticleInjector)blockEntity;
        injector.addParticle(this);
        if (injector.handleCollision()) {
            return;
        }
        if (this.facingDirection == null) return;
        if (this.facingDirection == Direction.UP) return;
        if (this.facingDirection == Direction.DOWN) {
            return;
        }
        if (this.firstTick && isClientside) {
            this.firstTick = false;
            SoundBarrierMethods.playParticleSound(this);
        }
        int i = 0;
        int checks = (int)(Math.ceil(this.speed) * 2.0);
        float localSpeed = this.speed / (float)checks;
        while (i < checks) {
            Vector3d proposedMove;
            block59: {
                Direction nextDir;
                Direction oldDir;
                BlockState proposedMoveState;
                boolean startOfLoopStateIsBooster;
                BlockState startOfLoopState;
                block58: {
                    BlockPos proposedMoveBlockPos;
                    block54: {
                        block53: {
                            Direction clockwise;
                            Direction otherSwitchDirection;
                            block55: {
                                block56: {
                                    Direction counterClockwise;
                                    block57: {
                                        ++i;
                                        startOfLoopState = this.field_70170_p.func_180495_p(this.func_233580_cy_());
                                        startOfLoopStateIsBooster = this.isBooster(startOfLoopState);
                                        boolean startofLoopStateIsDiode = this.isDiode(startOfLoopState);
                                        proposedMove = new Vector3d(this.func_226277_ct_() + (double)((float)this.facingDirection.func_82601_c() * localSpeed), this.func_226278_cu_(), this.func_226281_cx_() + (double)((float)this.facingDirection.func_82599_e() * localSpeed));
                                        if (startOfLoopStateIsBooster) {
                                            Direction boosterFacing = ((Direction)startOfLoopState.func_177229_b((Property)VoltaicBlockStates.FACING)).func_176734_d();
                                            FacingDirection boosterOrientation = (FacingDirection)((Object)startOfLoopState.func_177229_b((Property)NuclearScienceBlockStates.FACINGDIRECTION));
                                            if (boosterOrientation == FacingDirection.RIGHT) {
                                                boosterFacing = boosterFacing.func_176746_e();
                                            } else if (boosterOrientation == FacingDirection.LEFT) {
                                                boosterFacing = boosterFacing.func_176735_f();
                                            }
                                            if (boosterFacing == this.facingDirection) {
                                                this.setSpeed(this.speed += 0.0033333332f);
                                            } else if (boosterFacing == this.facingDirection.func_176734_d()) {
                                                this.setSpeed(this.speed += -0.02f);
                                            } else {
                                                this.setSpeed(this.speed *= 0.9f);
                                                this.facingDirection = boosterFacing;
                                                BlockPos floor = this.func_233580_cy_();
                                                proposedMove = new Vector3d((double)floor.func_177958_n() + 0.5, (double)floor.func_177956_o() + 0.5, (double)floor.func_177952_p() + 0.5);
                                            }
                                        }
                                        if (this.speed < 0.0f) {
                                            this.setSpeed(this.speed *= -1.0f);
                                            this.facingDirection = this.facingDirection.func_176734_d();
                                        }
                                        proposedMoveBlockPos = new BlockPos((int)Math.floor(proposedMove.func_82615_a()), (int)Math.floor(proposedMove.func_82617_b()), (int)Math.floor(proposedMove.func_82616_c()));
                                        if (!startOfLoopStateIsBooster && !startofLoopStateIsDiode || this.passedThroughSwitch || !this.isSwitch(this.field_70170_p.func_180495_p(proposedMoveBlockPos))) break block54;
                                        if (!injector.particles[0].func_110124_au().equals(this.func_110124_au())) break block55;
                                        if (injector.particles[1] == null || !injector.particles[1].passedThroughSwitch) break block56;
                                        otherSwitchDirection = injector.particles[1].switchDirection;
                                        clockwise = this.facingDirection.func_176746_e();
                                        counterClockwise = this.facingDirection.func_176735_f();
                                        if (this.facingDirection == otherSwitchDirection || !this.field_70170_p.func_180495_p(proposedMoveBlockPos.func_177972_a(this.facingDirection)).isAir((IBlockReader)this.field_70170_p, proposedMoveBlockPos.func_177972_a(this.facingDirection))) break block57;
                                        this.switchDirection = this.facingDirection;
                                        this.passedThroughSwitch = true;
                                        break block53;
                                    }
                                    if (clockwise != otherSwitchDirection && this.field_70170_p.func_180495_p(proposedMoveBlockPos.func_177972_a(clockwise)).isAir((IBlockReader)this.field_70170_p, proposedMoveBlockPos.func_177972_a(clockwise))) {
                                        this.switchDirection = clockwise;
                                        this.passedThroughSwitch = true;
                                        break block53;
                                    } else if (counterClockwise != otherSwitchDirection && this.field_70170_p.func_180495_p(proposedMoveBlockPos.func_177972_a(counterClockwise)).isAir((IBlockReader)this.field_70170_p, proposedMoveBlockPos.func_177972_a(counterClockwise))) {
                                        this.switchDirection = counterClockwise;
                                        this.passedThroughSwitch = true;
                                        break block53;
                                    } else {
                                        if (!isServerside) return;
                                        this.field_70170_p.func_217385_a((Entity)this, proposedMove.func_82615_a(), proposedMove.func_82617_b(), proposedMove.func_82616_c(), this.speed, Explosion.Mode.BREAK);
                                        this.func_241204_bJ_();
                                        return;
                                    }
                                }
                                Direction clockwise2 = this.facingDirection.func_176746_e();
                                Direction counterClockwise = this.facingDirection.func_176735_f();
                                if (this.field_70170_p.func_180495_p(proposedMoveBlockPos.func_177972_a(this.facingDirection)).isAir((IBlockReader)this.field_70170_p, proposedMoveBlockPos.func_177972_a(this.facingDirection))) {
                                    this.switchDirection = this.facingDirection;
                                    this.passedThroughSwitch = true;
                                    break block53;
                                } else if (this.field_70170_p.func_180495_p(proposedMoveBlockPos.func_177972_a(clockwise2)).isAir((IBlockReader)this.field_70170_p, proposedMoveBlockPos.func_177972_a(clockwise2))) {
                                    this.switchDirection = clockwise2;
                                    this.passedThroughSwitch = true;
                                    break block53;
                                } else {
                                    if (!this.field_70170_p.func_180495_p(proposedMoveBlockPos.func_177972_a(counterClockwise)).isAir((IBlockReader)this.field_70170_p, proposedMoveBlockPos.func_177972_a(counterClockwise))) {
                                        if (!isServerside) return;
                                        this.field_70170_p.func_217385_a((Entity)this, proposedMove.func_82615_a(), proposedMove.func_82617_b(), proposedMove.func_82616_c(), this.speed, Explosion.Mode.BREAK);
                                        this.func_241204_bJ_();
                                        return;
                                    }
                                    this.switchDirection = counterClockwise;
                                    this.passedThroughSwitch = true;
                                }
                                break block53;
                            }
                            if (!injector.particles[1].func_110124_au().equals(this.func_110124_au())) {
                                if (!isServerside) return;
                                this.field_70170_p.func_217385_a((Entity)this, proposedMove.func_82615_a(), proposedMove.func_82617_b(), proposedMove.func_82616_c(), this.speed, Explosion.Mode.BREAK);
                                this.func_241204_bJ_();
                                return;
                            }
                            if (!injector.particles[0].passedThroughSwitch) {
                                if (!isServerside) return;
                                this.field_70170_p.func_217385_a((Entity)this, proposedMove.func_82615_a(), proposedMove.func_82617_b(), proposedMove.func_82616_c(), this.speed, Explosion.Mode.BREAK);
                                this.func_241204_bJ_();
                                return;
                            }
                            otherSwitchDirection = injector.particles[0].switchDirection;
                            clockwise = this.facingDirection.func_176746_e();
                            Direction counterClockwise = this.facingDirection.func_176735_f();
                            if (this.facingDirection != otherSwitchDirection && this.field_70170_p.func_180495_p(proposedMoveBlockPos.func_177972_a(this.facingDirection)).isAir((IBlockReader)this.field_70170_p, proposedMoveBlockPos.func_177972_a(this.facingDirection))) {
                                this.switchDirection = this.facingDirection;
                                this.passedThroughSwitch = true;
                            } else if (clockwise != otherSwitchDirection && this.field_70170_p.func_180495_p(proposedMoveBlockPos.func_177972_a(clockwise)).isAir((IBlockReader)this.field_70170_p, proposedMoveBlockPos.func_177972_a(clockwise))) {
                                this.switchDirection = clockwise;
                                this.passedThroughSwitch = true;
                            } else if (counterClockwise != otherSwitchDirection && this.field_70170_p.func_180495_p(proposedMoveBlockPos.func_177972_a(counterClockwise)).isAir((IBlockReader)this.field_70170_p, proposedMoveBlockPos.func_177972_a(counterClockwise))) {
                                this.switchDirection = counterClockwise;
                                this.passedThroughSwitch = true;
                            } else {
                                if (!isServerside) return;
                                this.field_70170_p.func_217385_a((Entity)this, proposedMove.func_82615_a(), proposedMove.func_82617_b(), proposedMove.func_82616_c(), this.speed, Explosion.Mode.BREAK);
                                this.func_241204_bJ_();
                                return;
                            }
                        }
                        if (this.switchDirection != this.facingDirection) {
                            this.facingDirection = this.switchDirection;
                            proposedMove = new Vector3d((double)proposedMoveBlockPos.func_177958_n() + 0.5, (double)proposedMoveBlockPos.func_177956_o() + 0.5, (double)proposedMoveBlockPos.func_177952_p() + 0.5);
                        }
                    }
                    if (!(proposedMoveState = this.field_70170_p.func_180495_p(proposedMoveBlockPos)).isAir((IBlockReader)this.field_70170_p, proposedMoveBlockPos) && !this.isSwitch(proposedMoveState) && !this.isGateway(proposedMoveState) && !this.isDiode(proposedMoveState)) break block58;
                    int amount = 0;
                    for (Direction dir : Direction.values()) {
                        if (!this.field_70170_p.func_180495_p(proposedMoveBlockPos.func_177972_a(dir)).func_235714_a_(NuclearScienceTags.Blocks.PARTICLE_CONTAINMENT)) continue;
                        ++amount;
                    }
                    if (amount < 4) {
                        if (!isServerside) return;
                        this.field_70170_p.func_217385_a((Entity)this, proposedMove.func_82615_a(), proposedMove.func_82617_b(), proposedMove.func_82616_c(), this.speed, Explosion.Mode.BREAK);
                        this.func_241204_bJ_();
                        return;
                    }
                    BlockPos inFrontOfUs = proposedMoveBlockPos.func_177972_a(this.facingDirection);
                    BlockState inFrontOfUsState = this.field_70170_p.func_180495_p(inFrontOfUs);
                    boolean canPassThroughGateway = this.canPassThroughGateway(this.field_70170_p.func_175625_s(inFrontOfUs), inFrontOfUsState);
                    if (canPassThroughGateway && !this.passedThroughGate) {
                        this.field_70170_p.func_184133_a(null, proposedMoveBlockPos, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        this.passedThroughGate = true;
                        injector.timeSinceSpawn += 5;
                    }
                    if (!(!inFrontOfUsState.func_235714_a_(NuclearScienceTags.Blocks.PARTICLE_CONTAINMENT) || this.isBooster(inFrontOfUsState) || this.isSwitch(inFrontOfUsState) || canPassThroughGateway || this.canPassThroughDiode(inFrontOfUsState, this.facingDirection))) {
                        Direction checkRot = this.facingDirection.func_176746_e();
                        BlockPos relative = proposedMoveBlockPos.func_177972_a(checkRot);
                        inFrontOfUsState = this.field_70170_p.func_180495_p(relative);
                        if (inFrontOfUsState.isAir((IBlockReader)this.field_70170_p, relative) || this.isBooster(inFrontOfUsState) && !this.passedThroughSwitch || this.isSwitch(inFrontOfUsState) || this.canPassThroughGateway(this.field_70170_p.func_175625_s(relative), inFrontOfUsState) || this.canPassThroughDiode(inFrontOfUsState, checkRot)) {
                            this.facingDirection = checkRot;
                            proposedMove = new Vector3d((double)proposedMoveBlockPos.func_177958_n() + 0.5, (double)proposedMoveBlockPos.func_177956_o() + 0.5, (double)proposedMoveBlockPos.func_177952_p() + 0.5);
                            if (!this.passedThroughGate && !this.passedThroughSwitch) {
                                this.setSpeed(this.speed *= 0.9f);
                            }
                            break block59;
                        } else {
                            checkRot = this.facingDirection.func_176735_f();
                            relative = proposedMoveBlockPos.func_177972_a(checkRot);
                            inFrontOfUsState = this.field_70170_p.func_180495_p(relative);
                            if (!(inFrontOfUsState.isAir((IBlockReader)this.field_70170_p, relative) || this.isBooster(inFrontOfUsState) || this.passedThroughSwitch || this.isSwitch(inFrontOfUsState) || this.canPassThroughGateway(this.field_70170_p.func_175625_s(relative), inFrontOfUsState) || this.canPassThroughDiode(inFrontOfUsState, checkRot))) {
                                if (!isServerside) return;
                                this.field_70170_p.func_217385_a((Entity)this, proposedMove.func_82615_a(), proposedMove.func_82617_b(), proposedMove.func_82616_c(), this.speed, Explosion.Mode.BREAK);
                                this.func_241204_bJ_();
                                return;
                            }
                            this.facingDirection = checkRot;
                            if (!this.passedThroughGate && !this.passedThroughSwitch) {
                                this.setSpeed(this.speed *= 0.9f);
                            }
                            proposedMove = new Vector3d((double)proposedMoveBlockPos.func_177958_n() + 0.5, (double)proposedMoveBlockPos.func_177956_o() + 0.5, (double)proposedMoveBlockPos.func_177952_p() + 0.5);
                        }
                    }
                    break block59;
                }
                boolean checkIsBooster = this.isBooster(proposedMoveState) && startOfLoopStateIsBooster;
                boolean explode = false;
                if (checkIsBooster && (oldDir = (Direction)startOfLoopState.func_177229_b((Property)VoltaicBlockStates.FACING)) != (nextDir = (Direction)proposedMoveState.func_177229_b((Property)VoltaicBlockStates.FACING))) {
                    FacingDirection face = (FacingDirection)((Object)startOfLoopState.func_177229_b((Property)NuclearScienceBlockStates.FACINGDIRECTION));
                    if (face == FacingDirection.RIGHT) {
                        oldDir = oldDir.func_176746_e();
                    } else if (face == FacingDirection.LEFT) {
                        oldDir = oldDir.func_176735_f();
                    }
                    if (oldDir != nextDir) {
                        explode = true;
                    }
                }
                if (explode) {
                    if (!isServerside) return;
                    this.field_70170_p.func_217385_a((Entity)this, proposedMove.func_82615_a(), proposedMove.func_82617_b(), proposedMove.func_82616_c(), this.speed, Explosion.Mode.BREAK);
                    this.func_241204_bJ_();
                    return;
                }
            }
            this.func_70107_b(proposedMove.field_72450_a, proposedMove.field_72448_b, proposedMove.field_72449_c);
        }
    }

    public boolean isBooster(BlockState state) {
        return state.func_203425_a((Block)NuclearScienceBlocks.BLOCK_ELECTORMAGNETICBOOSTER.get());
    }

    public boolean isSwitch(BlockState state) {
        return state.func_203425_a((Block)NuclearScienceBlocks.BLOCK_ELECTROMAGNETICSWITCH.get());
    }

    public boolean isGateway(BlockState state) {
        return state.func_203425_a((Block)NuclearScienceBlocks.BLOCK_ELECTROMAGNETICGATEWAY.get());
    }

    public boolean isDiode(BlockState state) {
        return state.func_203425_a((Block)NuclearScienceBlocks.BLOCK_ELECTROMAGNETICDIODE.get());
    }

    public boolean canPassThroughGateway(TileEntity entity, BlockState state) {
        return this.isGateway(state) && entity instanceof TileElectromagneticGateway && ((TileElectromagneticGateway)entity).mayPassThrough(this.speed);
    }

    public boolean canPassThroughDiode(BlockState state, Direction facing) {
        return this.isDiode(state) && state.func_177229_b((Property)VoltaicBlockStates.FACING) == facing;
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected void func_70037_a(CompoundNBT compound) {
        BlockPos.field_239578_a_.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compound.func_74781_a("injector")).result().ifPresent(pair -> {
            this.source = (BlockPos)pair.getFirst();
        });
        this.passedThroughGate = compound.func_74767_n("passedthroughgate");
        this.ticksAlive = compound.func_74762_e("ticksalive");
        this.facingDirection = Direction.values()[compound.func_74762_e("facing")];
        this.switchDirection = Direction.values()[compound.func_74762_e("switch")];
        this.speed = compound.func_74760_g("speed");
        this.passedThroughSwitch = compound.func_74767_n("passedthroughswitch");
    }

    protected void func_213281_b(CompoundNBT compound) {
        BlockPos.field_239578_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.source).result().ifPresent(tag -> compound.func_218657_a("injector", tag));
        compound.func_74757_a("passedthroughgate", this.passedThroughGate);
        compound.func_74768_a("ticksalive", this.ticksAlive);
        compound.func_74768_a("facing", this.facingDirection.ordinal());
        compound.func_74776_a("speed", this.speed);
        compound.func_74768_a("switch", this.switchDirection.ordinal());
        compound.func_74757_a("passedthroughswitch", this.passedThroughSwitch);
    }

    protected ITextComponent func_225513_by_() {
        return new TranslationTextComponent("entity.particle");
    }

    public void setSpeed(float speed) {
        float sign = Math.signum(speed);
        if (speed > 2.0f || speed < -2.0f) {
            speed = 2.0f * sign;
        }
        this.speed = speed;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

