/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.event;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import nuclearscience.NuclearScience;
import nuclearscience.api.capability.CapabilityAntimatterItem;
import nuclearscience.api.quantumtunnel.CapabilityChannelMap;
import nuclearscience.api.quantumtunnel.CapabilityTunnelMap;
import nuclearscience.common.command.CommandWipeAllFrequencies;
import nuclearscience.common.command.CommandWipePublicFrequencies;
import nuclearscience.common.reloadlistener.AtomicAssemblerBlacklistRegister;
import nuclearscience.common.reloadlistener.AtomicAssemblerWhitelistRegister;
import nuclearscience.prefab.utils.NuclearCapabilityUtils;
import nuclearscience.registers.NuclearScienceCapabilities;

@Mod.EventBusSubscriber(modid="nuclearscience", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEventHandler {
    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)AtomicAssemblerBlacklistRegister.INSTANCE);
        event.addListener((IFutureReloadListener)AtomicAssemblerWhitelistRegister.INSTANCE);
    }

    @SubscribeEvent
    public static void serverStartedHandler(FMLServerStartedEvent event) {
        AtomicAssemblerBlacklistRegister.INSTANCE.generateTagValues();
        AtomicAssemblerWhitelistRegister.INSTANCE.generateTagValues();
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandWipeAllFrequencies.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        CommandWipePublicFrequencies.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerLevelCaps(AttachCapabilitiesEvent<World> event) {
        World world = (World)event.getObject();
        if (world != null && world.func_234923_W_().equals(World.field_234918_g_) && world.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP) == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            event.addCapability(NuclearScience.rl("tunnelmap"), (ICapabilityProvider)new CapabilityTunnelMap());
        }
        if (world != null && world.func_234923_W_().equals(World.field_234918_g_) && world.getCapability(NuclearScienceCapabilities.CAPABILITY_CHANNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_CHANNELMAP) == NuclearCapabilityUtils.EMPTY_CHANNELMAP) {
            event.addCapability(NuclearScience.rl("channelmap"), (ICapabilityProvider)new CapabilityChannelMap());
        }
    }

    @SubscribeEvent
    public static void registerEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof ItemEntity && ((ItemEntity)entity).getCapability(NuclearScienceCapabilities.CAPABILITY_ANTIMATTERITEM).orElse((Object)NuclearCapabilityUtils.EMPTY_ANTIMATTERITEM) == NuclearCapabilityUtils.EMPTY_ANTIMATTERITEM) {
            event.addCapability(NuclearScience.rl("antimatteritem"), (ICapabilityProvider)new CapabilityAntimatterItem());
        }
    }
}

