/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.item;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import nuclearscience.common.tile.TileTeleporter;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.common.item.ItemVoltaic;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.NBTUtils;

public class ItemFrequencyCard
extends ItemVoltaic {
    public ItemFrequencyCard(Item.Properties properties, Supplier<ItemGroup> creativeTab) {
        super(properties.func_200917_a(1), creativeTab);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        World level = context.func_195991_k();
        if (level.field_72995_K) {
            return super.onItemUseFirst(stack, context);
        }
        TileEntity blockentity = context.func_195991_k().func_175625_s(context.func_195995_a());
        if (blockentity instanceof TileTeleporter) {
            TileTeleporter teleporter = (TileTeleporter)blockentity;
            CompoundNBT nbt = stack.func_196082_o();
            if (nbt.func_74764_b("dimension")) {
                BlockPos pos = ItemFrequencyCard.readBlockPos(stack);
                RegistryKey<World> world = ItemFrequencyCard.readDimension(stack);
                teleporter.destination.setValue((Object)pos);
                teleporter.dimension.setValue(world);
                StringTextComponent worldKey = ElectroTextUtils.dimensionExists(world) ? ElectroTextUtils.dimension(world, (Object[])new Object[0]) : new StringTextComponent(world.func_240901_a_().func_110623_a());
                context.func_195999_j().func_145747_a((ITextComponent)NuclearTextUtils.tooltip("frequencycard.linked", worldKey.func_240702_b_(" " + pos.func_229422_x_())), Util.field_240973_b_);
            } else {
                ItemFrequencyCard.writeBlockPos(stack, teleporter.func_174877_v());
                ItemFrequencyCard.writeDimension(stack, (RegistryKey<World>)teleporter.func_145831_w().func_234923_W_());
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            BlockPos pos = ItemFrequencyCard.readBlockPos(stack);
            RegistryKey<World> world = ItemFrequencyCard.readDimension(stack);
            StringTextComponent worldKey = ElectroTextUtils.dimensionExists(world) ? ElectroTextUtils.dimension(world, (Object[])new Object[0]) : new StringTextComponent(world.func_240901_a_().func_110623_a());
            tooltip.add((ITextComponent)NuclearTextUtils.tooltip("frequencycard.linked", worldKey.func_240702_b_(" " + pos.func_229422_x_())));
        } else {
            tooltip.add((ITextComponent)NuclearTextUtils.tooltip("frequencycard.notag", new Object[0]));
        }
    }

    public static void writeBlockPos(ItemStack item, BlockPos pos) {
        BlockPos.field_239578_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)pos).result().ifPresent(tag -> item.func_196082_o().func_218657_a("loc", tag));
    }

    public static BlockPos readBlockPos(ItemStack item) {
        return (BlockPos)BlockPos.field_239578_a_.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)item.func_196082_o().func_74781_a("loc")).result().orElse(Pair.of((Object)BlockEntityUtils.OUT_OF_REACH, (Object)new CompoundNBT())).getFirst();
    }

    public static void writeDimension(ItemStack stack, RegistryKey<World> dim) {
        stack.func_196082_o().func_218657_a("dimension", (INBT)NBTUtils.writeDimensionToTag(dim));
    }

    public static RegistryKey<World> readDimension(ItemStack stack) {
        return NBTUtils.readDimensionFromTag((CompoundNBT)stack.func_196082_o().func_74775_l("dimension"));
    }
}

