/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.item;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import nuclearscience.prefab.utils.NuclearTextUtils;
import nuclearscience.registers.NuclearScienceSounds;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.item.IItemElectric;
import voltaic.api.radiation.util.IRadiationRecipient;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.item.ItemElectric;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class ItemGeigerCounter
extends ItemElectric {
    public static final double POWER_USAGE = 20.0;

    public ItemGeigerCounter(ElectricItemProperties properties, Supplier<ItemGroup> creativeTab) {
        super(properties, creativeTab);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof PlayerEntity && !worldIn.field_72995_K) {
            PlayerEntity player = (PlayerEntity)entityIn;
            boolean noPower = this.getJoulesStored(stack) < 20.0;
            IRadiationRecipient capability = (IRadiationRecipient)player.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONRECIPIENT).orElse((Object)CapabilityUtils.EMPTY_RADIATION_REPIPIENT);
            if (capability == CapabilityUtils.EMPTY_RADIATION_REPIPIENT) {
                return;
            }
            RadioactiveObject recievedRads = capability.getRecievedRadiation((LivingEntity)player);
            if (isSelected || player.func_184582_a(EquipmentSlotType.OFFHAND).func_77973_b() instanceof ItemGeigerCounter) {
                if (noPower) {
                    player.func_146105_b((ITextComponent)NuclearTextUtils.chatMessage("geigercounter.nopower", new Object[0]), true);
                } else {
                    player.func_146105_b((ITextComponent)ChatFormatter.getChatDisplay((double)recievedRads.amount(), (IDisplayUnit)DisplayUnits.RAD, (int)3, (boolean)true), true);
                }
            }
            if (!noPower && recievedRads.amount() > 0.0 && (double)(worldIn.field_73012_v.nextFloat() * 50.0f) * 60.995 / 3.0 < recievedRads.amount()) {
                SoundEvent sound;
                switch (worldIn.field_73012_v.nextInt(6)) {
                    case 1: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_2.get();
                        break;
                    }
                    case 2: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_3.get();
                        break;
                    }
                    case 3: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_4.get();
                        break;
                    }
                    case 4: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_5.get();
                        break;
                    }
                    case 5: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_6.get();
                        break;
                    }
                    default: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_1.get();
                    }
                }
                worldIn.func_184133_a(null, player.func_233580_cy_(), sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                IItemElectric.setEnergyStored((ItemStack)stack, (double)(this.getJoulesStored(stack) - 20.0));
                player.field_71071_by.func_70299_a(itemSlot, stack);
                player.field_71071_by.func_70296_d();
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }
}

