/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.network;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import nuclearscience.common.block.subtype.SubtypeMoltenSaltPipe;
import nuclearscience.common.tile.reactor.moltensalt.TileHeatExchanger;
import nuclearscience.common.tile.reactor.moltensalt.TileMoltenSaltPipe;
import voltaic.api.network.ITickableNetwork;
import voltaic.common.network.NetworkRegistry;
import voltaic.prefab.network.AbstractNetwork;

public class MoltenSaltNetwork
extends AbstractNetwork<TileMoltenSaltPipe, SubtypeMoltenSaltPipe, Double, MoltenSaltNetwork> {
    public MoltenSaltNetwork(Collection<TileMoltenSaltPipe> varCables) {
        this.conductorSet.addAll(varCables);
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public MoltenSaltNetwork(Set<MoltenSaltNetwork> networks) {
        for (MoltenSaltNetwork net : networks) {
            this.conductorSet.addAll(net.conductorSet);
            net.deregister();
        }
        NetworkRegistry.register((ITickableNetwork)this);
    }

    public Double emit(Double transfer, ArrayList<TileEntity> ignored, boolean debug) {
        if (transfer <= 0.0) {
            return 0.0;
        }
        HashSet availableAcceptors = Sets.newHashSet((Iterable)this.acceptorSet);
        double heat = 0.0;
        availableAcceptors.removeAll(ignored);
        if (availableAcceptors.isEmpty()) {
            return 0.0;
        }
        double perReceiver = transfer / (double)availableAcceptors.size();
        for (TileEntity receiver : availableAcceptors) {
            if (receiver == null || receiver.func_145837_r()) {
                this.acceptorInputMap.remove(receiver);
                this.acceptorSet.remove(receiver);
                continue;
            }
            if (!this.acceptorInputMap.containsKey(receiver) || !(receiver instanceof TileHeatExchanger)) continue;
            Double rec = ((TileHeatExchanger)receiver).receiveHeat(perReceiver - (double)(this.getSize() * 5));
            heat += rec.doubleValue();
            this.transmittedThisTick += rec.doubleValue();
        }
        return heat;
    }

    public boolean isConductor(TileEntity tile, TileMoltenSaltPipe requesterCable) {
        return tile instanceof TileMoltenSaltPipe;
    }

    public MoltenSaltNetwork createInstanceConductor(Set<TileMoltenSaltPipe> conductors) {
        return new MoltenSaltNetwork((Collection<TileMoltenSaltPipe>)conductors);
    }
}

