/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet.type.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import nuclearscience.api.network.reactorlogistics.Interface;
import nuclearscience.common.packet.type.client.ClientBarrierMethods;
import voltaic.api.codec.StreamCodec;

public class PacketSetClientInterfaces {
    public static final StreamCodec<PacketBuffer, PacketSetClientInterfaces> CODEC = new StreamCodec<PacketBuffer, PacketSetClientInterfaces>(){

        public PacketSetClientInterfaces decode(PacketBuffer buf) {
            ArrayList<Interface> interfaces = new ArrayList<Interface>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                interfaces.add((Interface)Interface.STREAM_CODEC.decode((Object)buf));
            }
            return new PacketSetClientInterfaces((BlockPos)StreamCodec.BLOCK_POS.decode((Object)buf), interfaces);
        }

        public void encode(PacketBuffer buf, PacketSetClientInterfaces packet) {
            buf.writeInt(packet.interfaces.size());
            for (Interface inter : packet.interfaces) {
                Interface.STREAM_CODEC.encode((Object)buf, (Object)inter);
            }
            StreamCodec.BLOCK_POS.encode((Object)buf, (Object)packet.pos);
        }
    };
    private final BlockPos pos;
    private final List<Interface> interfaces;

    public PacketSetClientInterfaces(BlockPos pos, List<Interface> interfaces) {
        this.pos = pos;
        this.interfaces = interfaces;
    }

    public static void handle(PacketSetClientInterfaces message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ClientBarrierMethods.handleSetClientInterfaces(message.pos, message.interfaces));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSetClientInterfaces pkt, PacketBuffer buf) {
        CODEC.encode((Object)buf, (Object)pkt);
    }

    public static PacketSetClientInterfaces decode(PacketBuffer buf) {
        return (PacketSetClientInterfaces)CODEC.decode((Object)buf);
    }
}

