/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet.type.server;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.common.packet.type.server.ServerBarrierMethods;
import voltaic.api.codec.StreamCodec;

public class PacketDeleteFrequency {
    public static final StreamCodec<PacketBuffer, PacketDeleteFrequency> CODEC = new StreamCodec<PacketBuffer, PacketDeleteFrequency>(){

        public PacketDeleteFrequency decode(PacketBuffer buf) {
            return new PacketDeleteFrequency((UUID)StreamCodec.UUID.decode((Object)buf), (TunnelFrequency)TunnelFrequency.STREAM_CODEC.decode((Object)buf));
        }

        public void encode(PacketBuffer buf, PacketDeleteFrequency packet) {
            StreamCodec.UUID.encode((Object)buf, (Object)packet.requester);
            TunnelFrequency.STREAM_CODEC.encode((Object)buf, (Object)packet.frequency);
        }
    };
    private final UUID requester;
    private final TunnelFrequency frequency;

    public PacketDeleteFrequency(UUID requester, TunnelFrequency frequency) {
        this.requester = requester;
        this.frequency = frequency;
    }

    public static void handle(PacketDeleteFrequency message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ServerBarrierMethods.deleteFrequency(message.requester, message.frequency));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketDeleteFrequency pkt, PacketBuffer buf) {
        CODEC.encode((Object)buf, (Object)pkt);
    }

    public static PacketDeleteFrequency decode(PacketBuffer buf) {
        return (PacketDeleteFrequency)CODEC.decode((Object)buf);
    }
}

