/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet.type.server;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.common.packet.type.server.ServerBarrierMethods;
import voltaic.api.codec.StreamCodec;

public class PacketEditFrequency {
    public static final StreamCodec<PacketBuffer, PacketEditFrequency> CODEC = new StreamCodec<PacketBuffer, PacketEditFrequency>(){

        public PacketEditFrequency decode(PacketBuffer buf) {
            return new PacketEditFrequency((UUID)StreamCodec.UUID.decode((Object)buf), (TunnelFrequency)TunnelFrequency.STREAM_CODEC.decode((Object)buf));
        }

        public void encode(PacketBuffer buf, PacketEditFrequency packet) {
            StreamCodec.UUID.encode((Object)buf, (Object)packet.requester);
            TunnelFrequency.STREAM_CODEC.encode((Object)buf, (Object)packet.frequency);
        }
    };
    private final UUID requester;
    private final TunnelFrequency frequency;

    public PacketEditFrequency(UUID requester, TunnelFrequency frequency) {
        this.requester = requester;
        this.frequency = frequency;
    }

    public static void handle(PacketEditFrequency message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ServerBarrierMethods.editFrequency(message.requester, message.frequency));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketEditFrequency pkt, PacketBuffer buf) {
        CODEC.encode((Object)buf, (Object)pkt);
    }

    public static PacketEditFrequency decode(PacketBuffer buf) {
        return (PacketEditFrequency)CODEC.decode((Object)buf);
    }
}

