/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.reloadlistener;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import nuclearscience.common.packet.type.client.PacketSetClientAtomicAssemblerWhitelistVals;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import voltaic.Voltaic;
import voltaic.prefab.reloadlistener.AbstractReloadListener;

public class AtomicAssemblerWhitelistRegister
extends AbstractReloadListener<JsonObject> {
    public static AtomicAssemblerWhitelistRegister INSTANCE = null;
    public static final String KEY = "values";
    public static final String FOLDER = "machines";
    public static final String FILE_NAME = "atomic_assembler_whitelist";
    protected static final String JSON_EXTENSION = ".json";
    protected static final int JSON_EXTENSION_LENGTH = ".json".length();
    private static final Gson GSON = new Gson();
    private final HashSet<Item> whitelistedItems = new HashSet();
    private final HashSet<ITag.INamedTag<Item>> tags = new HashSet();
    private final Logger logger = Voltaic.LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonObject prepare(IResourceManager manager, IProfiler profiler) {
        JsonObject blacklistedItems = new JsonObject();
        ArrayList resources = new ArrayList(manager.func_199003_a(FOLDER, AtomicAssemblerWhitelistRegister::isStringJsonFile));
        Collections.reverse(resources);
        JsonArray combinedArray = new JsonArray();
        for (ResourceLocation entry : resources) {
            String namespace = entry.func_110624_b();
            String filePath = entry.func_110623_a();
            String dataPath = filePath.substring(FOLDER.length() + 1, filePath.length() - JSON_EXTENSION_LENGTH);
            ResourceLocation jsonFile = new ResourceLocation(namespace, dataPath);
            try {
                for (IResource resource : manager.func_199004_b(jsonFile)) {
                    try {
                        InputStream inputStream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                            Throwable throwable2 = null;
                            try {
                                JsonObject json = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonElement.class);
                                combinedArray.addAll(json.get(KEY).getAsJsonArray());
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                ((Reader)reader).close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (IOException | RuntimeException exception) {
                        this.logger.error("Data loader for {} could not read data {} from file {} in data pack {}", (Object)FOLDER, (Object)jsonFile, (Object)entry, (Object)resource.func_199029_a(), (Object)exception);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException exception) {
                this.logger.error("Data loader for {} could not read data {} from file {}", (Object)FOLDER, (Object)jsonFile, (Object)entry, (Object)exception);
            }
        }
        blacklistedItems.add(KEY, (JsonElement)combinedArray);
        return blacklistedItems;
    }

    protected void apply(JsonObject json, IResourceManager manager, IProfiler profiler) {
        this.whitelistedItems.clear();
        this.tags.clear();
        ArrayList list = (ArrayList)GSON.fromJson((JsonElement)json.get(KEY).getAsJsonArray(), ArrayList.class);
        list.forEach(key -> {
            if (key.charAt(0) == '#') {
                this.tags.add((ITag.INamedTag<Item>)ItemTags.createOptional((ResourceLocation)new ResourceLocation(key.substring(1))));
            } else {
                this.whitelistedItems.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(key)));
            }
        });
    }

    public void generateTagValues() {
        this.tags.forEach(tag -> {
            for (ItemStack item : Ingredient.func_199805_a((ITag)tag).func_193365_a()) {
                this.whitelistedItems.add(item.func_77973_b());
            }
        });
        this.tags.clear();
    }

    public void setClientValues(HashSet<Item> fuels) {
        this.whitelistedItems.clear();
        this.whitelistedItems.addAll(fuels);
    }

    public AtomicAssemblerWhitelistRegister subscribeAsSyncable(SimpleChannel channel) {
        MinecraftForge.EVENT_BUS.addListener(this.getDatapackSyncListener(channel));
        return this;
    }

    public HashSet<Item> getWhitelist() {
        return this.whitelistedItems;
    }

    public boolean isWhitelisted(Item item) {
        return this.whitelistedItems.contains(item);
    }

    private Consumer<OnDatapackSyncEvent> getDatapackSyncListener(SimpleChannel channel) {
        return event -> {
            this.generateTagValues();
            ServerPlayerEntity player = event.getPlayer();
            PacketSetClientAtomicAssemblerWhitelistVals packet = new PacketSetClientAtomicAssemblerWhitelistVals(this.whitelistedItems);
            PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
            channel.send(target, (Object)packet);
        };
    }

    private static boolean isStringJsonFile(String filename) {
        return filename.endsWith("atomic_assembler_whitelist.json");
    }
}

