/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import nuclearscience.common.inventory.container.ContainerAtomicAssembler;
import nuclearscience.common.reloadlistener.AtomicAssemblerBlacklistRegister;
import nuclearscience.common.reloadlistener.AtomicAssemblerWhitelistRegister;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileAtomicAssembler
extends GenericTile {
    public final SingleProperty<Integer> progress = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "progress", (Object)0));

    public TileAtomicAssembler() {
        super((TileEntityType)NuclearScienceTiles.TILE_ATOMICASSEMBLER.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickCommon(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).maxJoules(NuclearConstants.ATOMICASSEMBLER_USAGE_PER_TICK * 20.0).voltage(NuclearConstants.ATOMICASSEMBLER_VOLTAGE).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(7).outputs(1)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1, 2, 3, 4, 5}).setDirectionsBySlot(Integer.valueOf(6), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.BACK}).setDirectionsBySlot(Integer.valueOf(7), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.FRONT}).valid((slot, stack, i) -> slot == 6 || slot < 6 && stack.func_77973_b() == NuclearScienceItems.ITEM_CELLDARKMATTER.get()));
        this.addComponent((IComponent)new ComponentContainerProvider("atomicassembler", (GenericTile)this).createMenu((id, player) -> new ContainerAtomicAssembler((int)id, (PlayerInventory)player, (IInventory)this.getComponent(IComponentType.Inventory), this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tickable) {
        boolean validItem;
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = inv.func_70301_a(6);
        if (input.func_190926_b()) {
            this.progress.setValue((Object)0);
            return;
        }
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)inv, (int)NuclearConstants.ATOMIC_ASSEMBLER_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)true, (boolean)false);
        ItemStack output = inv.func_70301_a(7);
        boolean bl = validItem = this.validateDupeItem(input) && (output.func_190926_b() || ItemStack.func_179545_c((ItemStack)input, (ItemStack)output) && output.func_190916_E() + 1 <= output.func_77976_d());
        if (!validItem) {
            this.progress.setValue((Object)0);
            return;
        }
        for (int index = 0; index < 6; ++index) {
            ItemStack dmCell = inv.func_70301_a(index);
            if (dmCell.func_190926_b() || dmCell.func_77973_b() != NuclearScienceItems.ITEM_CELLDARKMATTER.get()) {
                this.progress.setValue((Object)0);
                return;
            }
            if (dmCell.func_77952_i() < dmCell.func_77958_k()) continue;
            this.progress.setValue((Object)0);
            inv.func_70299_a(index, ItemStack.field_190927_a);
            return;
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < NuclearConstants.ATOMICASSEMBLER_USAGE_PER_TICK) {
            return;
        }
        this.progress.setValue((Object)((Integer)this.progress.getValue() + 1));
        electro.joules(electro.getJoulesStored() - NuclearConstants.ATOMICASSEMBLER_USAGE_PER_TICK);
        if ((Integer)this.progress.getValue() < NuclearConstants.ATOMICASSEMBLER_REQUIRED_TICKS) {
            return;
        }
        this.progress.setValue((Object)0);
        for (int index = 0; index < 6; ++index) {
            ItemStack dmCell = inv.func_70301_a(index);
            dmCell.func_196085_b(dmCell.func_77952_i() + 1);
            if (dmCell.func_77952_i() < dmCell.func_77958_k()) continue;
            inv.func_70299_a(index, ItemStack.field_190927_a);
        }
        if (output.func_190926_b()) {
            inv.func_70299_a(7, new ItemStack((IItemProvider)input.func_77973_b()));
        } else {
            output.func_190920_e(output.func_190916_E() + 1);
        }
    }

    private boolean validateDupeItem(ItemStack stack) {
        if (AtomicAssemblerWhitelistRegister.INSTANCE.isWhitelisted(stack.func_77973_b())) {
            return true;
        }
        if (AtomicAssemblerBlacklistRegister.INSTANCE.isBlacklisted(stack.func_77973_b())) {
            return false;
        }
        if (stack.func_77942_o()) {
            return false;
        }
        return !ItemUtils.testItems((Item)stack.func_77973_b(), (Item[])new Item[]{(Item)NuclearScienceItems.ITEM_CELLDARKMATTER.get()}) || stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER) == CapabilityUtils.EMPTY_ITEM_HANDLER;
    }
}

