/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import nuclearscience.common.inventory.container.ContainerChemicalExtractor;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceRecipies;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileChemicalExtractor
extends GenericTile {
    public static final int MAX_TANK_CAPACITY = 5000;

    public TileChemicalExtractor() {
        super((TileEntityType)NuclearScienceTiles.TILE_CHEMICALEXTRACTOR.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(240.0));
        this.addComponent((IComponent)new ComponentFluidHandlerMulti((GenericTile)this).setInputTanks(1, new int[]{5000}).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.BACK, BlockEntityUtils.MachineDirection.LEFT}).setRecipeType(NuclearScienceRecipies.CHEMICAL_EXTRACTOR_TYPE));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(1, 1, 1, 0).bucketInputs(1).upgrades(3)).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.BACK}).setDirectionsBySlot(Integer.valueOf(1), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.BACK}).validUpgrades(ContainerChemicalExtractor.VALID_UPGRADES).valid(TileChemicalExtractor.machineValidator()));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess(this::canProcess).process(ComponentProcessor::processFluidItem2ItemRecipe));
        this.addComponent((IComponent)new ComponentContainerProvider("chemicalextractor", (GenericTile)this).createMenu((id, player) -> new ContainerChemicalExtractor((int)id, (PlayerInventory)player, (IInventory)this.getComponent(IComponentType.Inventory), this.getCoordsArray())));
    }

    private boolean canProcess(ComponentProcessor processor, int procNumber) {
        processor.consumeBucket();
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)((ComponentInventory)this.getComponent(IComponentType.Inventory)), (int)NuclearConstants.CHEMICAL_EXTRACTOR_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)true, (boolean)false);
        RadiationUtils.handleRadioactiveFluids((GenericTile)this, (ComponentFluidHandlerMulti)((ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler)), (int)NuclearConstants.CHEMICAL_EXTRACTOR_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)true, (boolean)false);
        return processor.canProcessFluidItem2ItemRecipe(procNumber, NuclearScienceRecipies.CHEMICAL_EXTRACTOR_TYPE);
    }

    private void tickClient(ComponentTickable tickable) {
        if (((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) && this.field_145850_b.field_73012_v.nextDouble() < 0.15) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble() * 0.8 + 0.5, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public int getComparatorSignal() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) ? 15 : 0;
    }
}

