/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.Voltaic;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileChunkloader
extends GenericTile {
    public TileChunkloader() {
        super((TileEntityType)NuclearScienceTiles.TILE_CHUNKLOADER.get());
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
    }

    public void tickServer(ComponentTickable tickable) {
    }

    private void updateChunks(boolean load, World world, BlockPos pos) {
        int j;
        int i;
        int offset = 1;
        ChunkPos currChunkPos = world.func_217349_x(pos).func_76632_l();
        int lowerXOffset = currChunkPos.field_77276_a - offset;
        int lowerZOffset = currChunkPos.field_77275_b - offset;
        int delta = currChunkPos.field_77276_a + offset - lowerXOffset;
        BlockPos[][] ownerPos = new BlockPos[delta + 1][delta + 1];
        BlockPos bottomLeft = pos.func_177982_a(-16 * offset, 0, -16 * offset);
        for (i = 0; i <= delta; ++i) {
            for (j = 0; j <= delta; ++j) {
                ownerPos[i][j] = bottomLeft.func_177982_a(16 * i, 0, 16 * j);
            }
        }
        for (i = 0; i <= delta; ++i) {
            for (j = 0; j <= delta; ++j) {
                ForgeChunkManager.forceChunk((ServerWorld)((ServerWorld)world), (String)"nuclearscience", (BlockPos)ownerPos[i][j], (int)(lowerXOffset + i), (int)(lowerZOffset + j), (boolean)load, (boolean)true);
                String action = load ? "loading" : "unloading";
                Voltaic.LOGGER.info(action + " chunk at " + lowerXOffset + i + "," + lowerZOffset + j);
            }
        }
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.field_145850_b.func_201670_d()) {
            this.updateChunks(false, this.func_145831_w(), this.func_174877_v());
        }
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (!this.field_145850_b.func_201670_d()) {
            this.updateChunks(true, this.func_145831_w(), this.func_174877_v());
        }
    }
}

