/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import nuclearscience.client.event.levelstage.HandlerCloudChamber;
import nuclearscience.common.inventory.container.ContainerCloudChamber;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.RadiationSystem;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.ListProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileCloudChamber
extends GenericTile {
    public static final int HORR_RADIUS = 30;
    private static final int VERT_RADIUS = 30;
    public final ListProperty<BlockPos> sources = (ListProperty)this.property((AbstractProperty)new ListProperty(PropertyTypes.BLOCK_POS_LIST, "sources", new ArrayList()));
    public final SingleProperty<Boolean> active = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "active", (Object)false));
    public final SingleProperty<Boolean> sourcesDetected = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "detectedsources", (Object)false));
    private final SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));

    public TileCloudChamber() {
        super((TileEntityType)NuclearScienceTiles.TILE_CLOUDCHAMBER.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(120.0).maxJoules(NuclearConstants.CLOUD_CHAMBER_ENERGY_USAGE_PER_TICK * 20.0));
        this.addComponent((IComponent)new ComponentFluidHandlerSimple(100, fluidStack -> fluidStack.getFluid().func_207185_a(NuclearScienceTags.Fluids.METHANOL), (GenericTile)this, "methanolstorage").setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}));
        this.addComponent((IComponent)new ComponentContainerProvider("cloudchamber", (GenericTile)this).createMenu((id, player) -> new ContainerCloudChamber((int)id, (PlayerInventory)player, (IInventory)new Inventory(new ItemStack[0]), this.getCoordsArray())));
    }

    private void tickClient(ComponentTickable tickable) {
        if (((Boolean)this.sourcesDetected.getValue()).booleanValue()) {
            HandlerCloudChamber.addSources(this);
        } else {
            HandlerCloudChamber.removeSources(this);
        }
    }

    private void tickServer(ComponentTickable tickable) {
        this.sources.wipeList();
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            this.active.setValue((Object)false);
            this.sourcesDetected.setValue((Object)false);
            return;
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < NuclearConstants.CLOUD_CHAMBER_ENERGY_USAGE_PER_TICK) {
            this.active.setValue((Object)false);
            this.sourcesDetected.setValue((Object)false);
            return;
        }
        ComponentFluidHandlerSimple fluid = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        if (fluid.isEmpty() || (double)fluid.getFluidAmount() < NuclearConstants.CLOUD_CHAMBER_ENERGY_USAGE_PER_TICK) {
            this.active.setValue((Object)false);
            this.sourcesDetected.setValue((Object)false);
            return;
        }
        this.active.setValue((Object)true);
        electro.setJoulesStored(electro.getJoulesStored() - NuclearConstants.CLOUD_CHAMBER_ENERGY_USAGE_PER_TICK);
        fluid.drain(NuclearConstants.CLOUD_CHAMBER_FLUID_USAGE_PER_TICK, IFluidHandler.FluidAction.EXECUTE);
        List sources = RadiationSystem.getRadiationSources((World)this.func_145831_w());
        ArrayList accepted = new ArrayList();
        BlockPos pos = this.func_174877_v();
        sources.forEach(source -> {
            int deltaX = source.func_177958_n() - pos.func_177958_n();
            int deltaY = source.func_177956_o() - pos.func_177956_o();
            int deltaZ = source.func_177952_p() - pos.func_177952_p();
            if (Math.abs(deltaY) > 30 || Math.abs(deltaX) > 30 || Math.abs(deltaZ) > 30) {
                return;
            }
            accepted.add(source);
        });
        this.sourcesDetected.setValue((Object)(!accepted.isEmpty() ? 1 : 0));
        if (accepted.isEmpty()) {
            return;
        }
        this.sources.addValues(accepted);
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (!this.field_145850_b.field_72995_K) {
            this.hasRedstoneSignal.setValue((Object)this.field_145850_b.func_175640_z(this.func_174877_v()));
        }
    }
}

