/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.registers.ElectrodynamicsSounds;
import net.minecraft.inventory.IInventory;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceRecipies;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.inventory.container.ContainerO2OProcessor;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileFuelReprocessor
extends GenericTile
implements ITickableSound {
    private boolean isSoundPlaying = false;

    public TileFuelReprocessor() {
        super((TileEntityType)NuclearScienceTiles.TILE_FUELREPROCESSOR.get());
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(480.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(1, 1, 1, 1).upgrades(3)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0}).setDirectionsBySlot(Integer.valueOf(1), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BOTTOM, new Integer[]{2}).validUpgrades(ContainerO2OProcessor.VALID_UPGRADES).valid(TileFuelReprocessor.machineValidator()));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess(this::shouldProcessRecipe).process(ComponentProcessor::processItem2ItemRecipe));
        this.addComponent((IComponent)new ComponentContainerProvider("fuelreprocessor", (GenericTile)this).createMenu((id, player) -> new ContainerO2OProcessor(id.intValue(), player, (IInventory)this.getComponent(IComponentType.Inventory), this.getCoordsArray())));
    }

    private boolean shouldProcessRecipe(ComponentProcessor component, int procNumber) {
        boolean canProcess = component.canProcessItem2ItemRecipe(procNumber, NuclearScienceRecipies.FUEL_REPROCESSOR_TYPE);
        if (BlockEntityUtils.isLit((GenericTile)this) ^ canProcess) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)canProcess);
        }
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)((ComponentInventory)this.getComponent(IComponentType.Inventory)), (int)NuclearConstants.FUEL_REPROCESSOR_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)true, (boolean)false);
        return canProcess;
    }

    public void tickClient(ComponentTickable tickable) {
        if (!this.isSoundPlaying && this.shouldPlaySound()) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_HUM.get()), (TileEntity)this, (boolean)true);
        }
        if (((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) && (double)this.func_145831_w().func_201674_k().nextFloat() < 0.3) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0);
    }

    public int getComparatorSignal() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) ? 15 : 0;
    }
}

