/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import nuclearscience.common.inventory.container.ContainerGasCentrifuge;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceSounds;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileGasCentrifuge
extends GenericTile
implements ITickableSound {
    public static final int TANKCAPACITY = 5000;
    public static final double REQUIRED = 2500.0;
    public static final double PERCENT_U235 = 0.172;
    public static final double WASTE_MULTIPLIER = 0.1;
    public SingleProperty<Integer> spinSpeed = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "spinSpeed", (Object)0));
    public SingleProperty<Double> stored235 = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "stored235", (Object)0.0));
    public SingleProperty<Double> stored238 = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "stored238", (Object)0.0));
    public SingleProperty<Double> storedWaste = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "storedWaste", (Object)0.0));
    public SingleProperty<Boolean> isRunning = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isRunning", (Object)false));
    private boolean isSoundPlaying = false;

    public TileGasCentrifuge() {
        super((TileEntityType)NuclearScienceTiles.TILE_GASCENTRIFUGE.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentFluidHandlerMulti((GenericTile)this).setInputTanks(1, TileGasCentrifuge.arr((int[])new int[]{5000})).setInputFluidTags(new ITag.INamedTag[]{NuclearScienceTags.Fluids.URANIUM_HEXAFLUORIDE}).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(240.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules(NuclearConstants.GASCENTRIFUGE_USAGE_PER_TICK * 10.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().outputs(3).upgrades(3)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1, 2}).setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, new Integer[]{0, 1, 2}).setSlotsByDirection(BlockEntityUtils.MachineDirection.LEFT, new Integer[]{0, 1, 2}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BACK, new Integer[]{0, 1, 2}).validUpgrades(ContainerGasCentrifuge.VALID_UPGRADES).valid(TileGasCentrifuge.machineValidator()));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).usage(NuclearConstants.GASCENTRIFUGE_USAGE_PER_TICK, 0).requiredTicks((long)NuclearConstants.GASCENTRIFUGE_REQUIRED_TICKS_PER_PROCESSING, 0).canProcess(this::canProcess).process(this::process));
        this.addComponent((IComponent)new ComponentContainerProvider("gascentrifuge", (GenericTile)this).createMenu((id, player) -> new ContainerGasCentrifuge((int)id, (PlayerInventory)player, (IInventory)this.getComponent(IComponentType.Inventory), this.getCoordsArray())));
    }

    public boolean canProcess(ComponentProcessor processor, int procNumber) {
        boolean val;
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ComponentFluidHandlerMulti fluidHandler = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
        RadiationUtils.handleRadioactiveFluids((GenericTile)this, (ComponentFluidHandlerMulti)fluidHandler, (int)NuclearConstants.GAS_CENTRIFUGE_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)true, (boolean)false);
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)inv, (int)NuclearConstants.GAS_CENTRIFUGE_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)true, (boolean)false);
        boolean hasGas = (double)fluidHandler.getInputTanks()[0].getFluidAmount() >= 41.666666666666664;
        boolean bl = val = electro.getJoulesStored() >= processor.getUsage(0) && hasGas && inv.func_70301_a(0).func_190916_E() < inv.func_70301_a(0).func_77976_d() && inv.func_70301_a(1).func_190916_E() < inv.func_70301_a(1).func_77976_d() && inv.func_70301_a(2).func_190916_E() < inv.func_70301_a(2).func_77976_d();
        if (!val && (Integer)this.spinSpeed.getValue() > 0) {
            this.spinSpeed.setValue((Object)0);
        }
        this.isRunning.setValue((Object)val);
        return val;
    }

    public void process(ComponentProcessor processor, int procNumber) {
        ItemStack stack;
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ComponentFluidHandlerMulti multi = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
        this.spinSpeed.setValue((Object)((Double)processor.operatingSpeed.getValue()).intValue());
        int processed = 41;
        PropertyFluidTank tank = multi.getInputTanks()[0];
        if (FluidTags.func_226157_a_().func_199910_a(NuclearScienceTags.Fluids.URANIUM_HEXAFLUORIDE.func_230234_a_()).func_230235_a_((Object)tank.getFluid().getFluid()) && tank.getFluidAmount() >= processed) {
            tank.drain(processed, IFluidHandler.FluidAction.EXECUTE);
        }
        this.stored235.setValue((Object)((Double)this.stored235.getValue() + (double)processed * 0.172));
        this.stored238.setValue((Object)((Double)this.stored238.getValue() + (double)processed * 0.7280000000000001));
        this.storedWaste.setValue((Object)((Double)this.stored235.getValue() + (double)processed * 0.1));
        if ((Double)this.stored235.getValue() > 2500.0) {
            stack = inv.func_70301_a(0);
            if (!stack.func_190926_b()) {
                stack.func_190920_e(stack.func_190916_E() + 1);
            } else {
                inv.func_70299_a(0, new ItemStack((IItemProvider)NuclearScienceItems.ITEM_URANIUM235.get()));
            }
            this.stored235.setValue((Object)((Double)this.stored235.getValue() - 2500.0));
        }
        if ((Double)this.stored238.getValue() > 2500.0) {
            stack = inv.func_70301_a(1);
            if (!stack.func_190926_b()) {
                stack.func_190920_e(stack.func_190916_E() + 1);
            } else {
                inv.func_70299_a(1, new ItemStack((IItemProvider)NuclearScienceItems.ITEM_URANIUM238.get()));
            }
            this.stored238.setValue((Object)((Double)this.stored238.getValue() - 2500.0));
        }
        if ((Double)this.storedWaste.getValue() > 2500.0) {
            stack = inv.func_70301_a(2);
            if (!stack.func_190926_b()) {
                stack.func_190917_f(1);
            } else {
                inv.func_70299_a(2, new ItemStack((IItemProvider)NuclearScienceItems.ITEM_FISSILEDUST.get(), 1));
            }
            this.storedWaste.setValue((Object)((Double)this.storedWaste.getValue() - 2500.0));
        }
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!this.isSoundPlaying && this.shouldPlaySound()) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)NuclearScienceSounds.SOUND_GASCENTRIFUGE.get()), (TileEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Integer)this.spinSpeed.getValue() > 0;
    }

    public int getComparatorSignal() {
        return (Boolean)this.isRunning.getValue() != false ? 15 : 0;
    }
}

