/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.utilities.ElectricityUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import nuclearscience.common.inventory.container.ContainerRadioisotopeGenerator;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.reloadlistener.RadioactiveItemRegister;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileRadioisotopeGenerator
extends GenericTile {
    protected CachedTileOutput output1;
    protected CachedTileOutput output2;

    public TileRadioisotopeGenerator() {
        super((TileEntityType)NuclearScienceTiles.TILE_RADIOISOTOPEGENERATOR.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).voltage(NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE).extractPower((x, y) -> TransferPack.EMPTY).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.TOP}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1)).setDirectionsBySlot(Integer.valueOf(0), BlockEntityUtils.MachineDirection.values()).valid((slot, stack, i) -> RadioactiveItemRegister.getValue((Item)stack.func_77973_b()).amount() > 0.0));
        this.addComponent((IComponent)new ComponentContainerProvider("radioisotopegenerator", (GenericTile)this).createMenu((id, player) -> new ContainerRadioisotopeGenerator((int)id, (PlayerInventory)player, (IInventory)this.getComponent(IComponentType.Inventory), this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentInventory inv;
        ItemStack input;
        if (this.output1 == null) {
            this.output1 = new CachedTileOutput(this.field_145850_b, this.field_174879_c.func_177972_a(Direction.UP));
        }
        if (this.output2 == null) {
            this.output2 = new CachedTileOutput(this.field_145850_b, this.field_174879_c.func_177972_a(Direction.DOWN));
        }
        if (tickable.getTicks() % 40L == 0L) {
            this.output1.update(this.field_174879_c.func_177972_a(Direction.UP));
            this.output2.update(this.field_174879_c.func_177972_a(Direction.DOWN));
        }
        if ((input = (inv = (ComponentInventory)this.getComponent(IComponentType.Inventory)).func_70301_a(0)).func_190926_b()) {
            return;
        }
        RadioactiveObject radiation = RadioactiveItemRegister.getValue((Item)input.func_77973_b());
        if (radiation.amount() <= 0.0) {
            return;
        }
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)inv, (int)NuclearConstants.RADIO_GENATOR_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)true, (boolean)false);
        double currentOutput = (double)input.func_190916_E() * NuclearConstants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * radiation.amount();
        if (currentOutput > 0.0) {
            TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / (NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE * 2.0)), (double)NuclearConstants.RADIOISOTOPEGENERATOR_VOLTAGE);
            if (this.output1.valid()) {
                ElectricityUtils.receivePower((TileEntity)((TileEntity)this.output1.getSafe()), (Direction)Direction.DOWN, (TransferPack)transfer, (boolean)false);
            }
            if (this.output2.valid()) {
                ElectricityUtils.receivePower((TileEntity)((TileEntity)this.output2.getSafe()), (Direction)Direction.UP, (TransferPack)transfer, (boolean)false);
            }
        }
    }

    public int getComparatorSignal() {
        ItemStack stack = ((ComponentInventory)this.getComponent(IComponentType.Inventory)).func_70301_a(0);
        if (stack.func_190926_b()) {
            return 0;
        }
        return (int)((double)stack.func_190916_E() / (double)stack.func_77976_d() * 15.0);
    }
}

