/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import nuclearscience.api.turbine.ISteamReceiver;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.registers.NuclearScienceFluids;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.network.utils.FluidUtilities;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileSteamFunnel
extends GenericTile
implements ISteamReceiver {
    public static final int INTERNAL_CAPACITY = 10000;
    public static final int MAX_TEMPERATURE = 20000;
    public static final int MAX_PRESSURE = 10;

    public TileSteamFunnel() {
        super((TileEntityType)NuclearScienceTiles.TILE_STEAMFUNNEL.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentFluidHandlerSimple(10000, (GenericTile)this, "storedsteam").setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP}).setValidFluidTags(new ITag.INamedTag[]{NuclearScienceTags.Fluids.STEAM}));
    }

    private void tickServer(ComponentTickable tickable) {
        ComponentFluidHandlerSimple handler = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        if (handler.isEmpty()) {
            return;
        }
        TileEntity blockentity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a());
        if (blockentity instanceof ISteamReceiver) {
            handler.drain(((ISteamReceiver)blockentity).receiveSteam(handler.getFluid().getTag().func_74762_e("temperature"), handler.getFluidAmount()), IFluidHandler.FluidAction.EXECUTE);
        }
        FluidUtilities.outputToPipe((GenericTile)this, (FluidTank[])handler.asArray(), (Direction[])new Direction[]{Direction.UP});
    }

    private void tickClient(ComponentTickable tickable) {
        ComponentFluidHandlerSimple handler = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        BlockPos above = this.func_174877_v().func_177984_a();
        if (!handler.isEmpty() && this.field_145850_b.func_175625_s(above) instanceof ISteamReceiver && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            double offsetFX = (double)above.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
            double offsetFY = (double)above.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
            double offsetFZ = (double)above.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int receiveSteam(int temperature, int amount) {
        if (this.field_145850_b.func_201670_d()) {
            return 0;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("temperature", temperature);
        return ((ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler)).fill(new FluidStack((Fluid)NuclearScienceFluids.FLUID_STEAM.get(), amount, tag), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public boolean isStillValid() {
        return this.func_145837_r();
    }

    public ActionResultType use(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }
}

