/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import nuclearscience.common.inventory.container.ContainerTeleporter;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileTeleporter
extends GenericTile {
    private static final DimensionManager MANAGER = new DimensionManager();
    public final SingleProperty<BlockPos> destination = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "location", (Object)BlockEntityUtils.OUT_OF_REACH));
    public final SingleProperty<Integer> cooldown = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "cooldown", (Object)0));
    public final SingleProperty<ResourceLocation> dimension = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.RESOURCE_LOCATION, "dimension", (Object)World.field_234918_g_.func_240901_a_()));

    public TileTeleporter() {
        super((TileEntityType)NuclearScienceTiles.TILE_TELEPORTER.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).maxJoules(NuclearConstants.TELEPORTER_USAGE_PER_TELEPORT * 20.0).voltage(480.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1)));
        this.addComponent((IComponent)new ComponentContainerProvider("teleporter", (GenericTile)this).createMenu((id, player) -> new ContainerTeleporter((int)id, (PlayerInventory)player, (IInventory)this.getComponent(IComponentType.Inventory), this.getCoordsArray())));
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.destination.setValue((Object)pos);
    }

    protected void tickServer(ComponentTickable tickable) {
        boolean powered;
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        boolean bl = powered = electro.getJoulesStored() > NuclearConstants.TELEPORTER_USAGE_PER_TELEPORT;
        if (BlockEntityUtils.isLit((GenericTile)this) ^ powered) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)powered);
        }
        if (((BlockPos)this.destination.getValue()).equals((Object)this.func_174877_v()) || electro.getJoulesStored() < electro.getMaxJoulesStored()) {
            return;
        }
        if ((Integer)this.cooldown.getValue() > 0) {
            this.cooldown.setValue((Object)((Integer)this.cooldown.getValue() - 1));
            return;
        }
        AxisAlignedBB entityCheckArea = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 2, 1));
        List players = this.func_145831_w().func_217394_a(EntityType.field_200729_aH, entityCheckArea, en -> true);
        if (players.isEmpty()) {
            this.cooldown.setValue((Object)5);
            return;
        }
        ServerWorld destinationLevel = this.getDestinationLevel();
        PlayerEntity player = (PlayerEntity)players.get(0);
        player.changeDimension(destinationLevel, (ITeleporter)MANAGER);
        BlockPos destPos = (BlockPos)this.destination.getValue();
        player.func_223102_j((double)destPos.func_177958_n() + 0.5, (double)destPos.func_177956_o() + 1.0, (double)destPos.func_177952_p() + 0.5);
        this.cooldown.setValue((Object)80);
        electro.joules(electro.getJoulesStored() - NuclearConstants.TELEPORTER_USAGE_PER_TELEPORT);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(3.0);
    }

    private ServerWorld getDestinationLevel() {
        ServerWorld level = ServerLifecycleHooks.getCurrentServer().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)((ResourceLocation)this.dimension.getValue())));
        if (level == null) {
            return (ServerWorld)this.func_145831_w();
        }
        return level;
    }

    private static final class DimensionManager
    implements ITeleporter {
        private DimensionManager() {
        }

        public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            return repositionEntity.apply(false);
        }

        @Nullable
        public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
            return new PortalInfo(entity.func_213303_ch(), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
        }

        public boolean isVanilla() {
            return false;
        }

        public boolean playTeleportSound(ServerPlayerEntity player, ServerWorld sourceWorld, ServerWorld destWorld) {
            return false;
        }
    }
}

