/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.utilities.ElectricityUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import nuclearscience.api.turbine.ISteamReceiver;
import nuclearscience.common.block.BlockTurbine;
import nuclearscience.registers.NuclearScienceSounds;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileTurbine
extends GenericTile
implements ITickableSound,
ISteamReceiver {
    public static final int MAX_STEAM = 3000000;
    public SingleProperty<Integer> spinSpeed = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "spinSpeed", (Object)0));
    public SingleProperty<Boolean> hasCore = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasCore", (Object)false));
    public SingleProperty<Boolean> isCore = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isCore", (Object)false));
    public SingleProperty<BlockPos> coreLocation = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "coreLocation", (Object)BlockEntityUtils.OUT_OF_REACH));
    public SingleProperty<Integer> currentVoltage = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "turbinecurvoltage", (Object)0));
    public SingleProperty<Integer> steam = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "steam", (Object)0));
    public SingleProperty<Integer> wait = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "wait", (Object)30));
    protected CachedTileOutput output;
    private boolean isSoundPlaying = false;
    private boolean destroyed = false;

    public TileTurbine() {
        super((TileEntityType)NuclearScienceTiles.TILE_TURBINE.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP}).setCapabilityTest(() -> (Boolean)this.hasCore.getValue() == false || (Boolean)this.isCore.getValue() != false));
    }

    public void constructStructure() {
        int j;
        int i;
        int radius = 1;
        for (i = -radius; i <= radius; ++i) {
            for (j = -radius; j <= radius; ++j) {
                TileEntity tile;
                if (i == 0 && j == 0 || (tile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + i, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + j))) instanceof TileTurbine && !((Boolean)((TileTurbine)tile).hasCore.getValue()).booleanValue()) continue;
                return;
            }
        }
        this.isCore.setValue((Object)true);
        for (i = -radius; i <= radius; ++i) {
            for (j = -radius; j <= radius; ++j) {
                BlockPos offset = new BlockPos(this.field_174879_c.func_177958_n() + i, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + j);
                ((TileTurbine)this.field_145850_b.func_175625_s(offset)).addToStructure(this);
                BlockState state = this.field_145850_b.func_180495_p(offset);
                this.field_145850_b.func_175656_a(offset, (BlockState)state.func_206870_a((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void deconstructStructure() {
        TileTurbine core;
        if (((Boolean)this.isCore.getValue()).booleanValue()) {
            int radius = 1;
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    BlockPos offset;
                    TileEntity tile;
                    if (i == 0 && j == 0 || !((tile = this.field_145850_b.func_175625_s(offset = new BlockPos(this.field_174879_c.func_177958_n() + i, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + j))) instanceof TileTurbine)) continue;
                    TileTurbine turbine = (TileTurbine)tile;
                    turbine.hasCore.setValue((Object)false);
                    turbine.coreLocation.setValue((Object)new BlockPos(0, 0, 0));
                    BlockState state = this.field_145850_b.func_180495_p(offset);
                    if (!state.func_235901_b_((Property)BlockTurbine.RENDER)) continue;
                    this.field_145850_b.func_175656_a(offset, (BlockState)state.func_206870_a((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(true)));
                }
            }
            this.isCore.setValue((Object)false);
            this.hasCore.setValue((Object)false);
            this.coreLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
            BlockState state = this.func_195044_w();
            if (state.func_235901_b_((Property)BlockTurbine.RENDER) && !this.destroyed) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(true)));
            }
        } else if (((Boolean)this.hasCore.getValue()).booleanValue() && (core = (TileTurbine)this.field_145850_b.func_175625_s((BlockPos)this.coreLocation.getValue())) != null) {
            core.deconstructStructure();
        }
    }

    protected void addToStructure(TileTurbine core) {
        this.coreLocation.setValue((Object)core.field_174879_c);
        this.hasCore.setValue((Object)true);
    }

    public void tickServer(ComponentTickable tickable) {
        ((ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).voltage((double)((Integer)this.currentVoltage.getValue()).intValue());
        if (this.output == null) {
            this.output = new CachedTileOutput(this.field_145850_b, this.field_174879_c.func_177972_a(Direction.UP));
        }
        this.spinSpeed.setValue((Object)((Integer)this.currentVoltage.getValue() / 120));
        this.output.update(this.field_174879_c.func_177972_a(Direction.UP));
        if (((Boolean)this.hasCore.getValue()).booleanValue() && !((Boolean)this.isCore.getValue()).booleanValue()) {
            this.currentVoltage.setValue((Object)0);
            return;
        }
        if ((Integer)this.steam.getValue() > 0 && (Integer)this.currentVoltage.getValue() > 0) {
            this.wait.setValue((Object)30);
            if (this.output.valid()) {
                TransferPack transfer = TransferPack.joulesVoltage((double)((double)((Integer)this.steam.getValue()).intValue() * ((Boolean)this.hasCore.getValue() != false ? 1.111 : 1.0)), (double)((Integer)this.currentVoltage.getValue()).intValue());
                ElectricityUtils.receivePower((TileEntity)((TileEntity)this.output.getSafe()), (Direction)Direction.DOWN, (TransferPack)transfer, (boolean)false);
                this.steam.setValue((Object)Math.max((Integer)this.steam.getValue() - Math.max(75, (Integer)this.steam.getValue()), 0));
            }
        } else {
            if ((Integer)this.wait.getValue() <= 0) {
                this.currentVoltage.setValue((Object)0);
                this.wait.setValue((Object)30);
            }
            this.wait.setValue((Object)((Integer)this.wait.getValue() - 1));
        }
    }

    public void tickClient(ComponentTickable tickable) {
        if (!this.isSoundPlaying && this.shouldPlaySound()) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)NuclearScienceSounds.SOUND_TURBINE.get()), (TileEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Integer)this.spinSpeed.getValue() > 0;
    }

    public ActionResultType use(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }

    @Override
    public int receiveSteam(int temperature, int amount) {
        TileEntity core;
        int room = 3000000 * ((Boolean)this.isCore.getValue() != false ? 9 : 1) - (Integer)this.steam.getValue();
        int accepted = room < amount ? room : amount;
        this.steam.setValue((Object)((Integer)this.steam.getValue() + accepted));
        if (temperature < 4300) {
            this.currentVoltage.setValue((Object)120);
        } else if (temperature < 6000) {
            this.currentVoltage.setValue((Object)240);
        } else {
            this.currentVoltage.setValue((Object)480);
        }
        if (!((Boolean)this.isCore.getValue()).booleanValue() && ((Boolean)this.hasCore.getValue()).booleanValue() && (core = this.field_145850_b.func_175625_s((BlockPos)this.coreLocation.getValue())) instanceof TileTurbine && ((Boolean)((TileTurbine)core).isCore.getValue()).booleanValue()) {
            accepted = ((TileTurbine)core).receiveSteam(temperature, amount);
            this.steam.setValue((Object)0);
        }
        return accepted;
    }

    @Override
    public boolean isStillValid() {
        return this.func_145837_r();
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.destroyed = true;
        this.deconstructStructure();
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && !((Boolean)this.func_195044_w().func_177229_b((Property)BlockTurbine.RENDER)).booleanValue() && !((Boolean)this.isCore.getValue()).booleanValue()) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return (Boolean)this.isCore.getValue() != false ? super.getRenderBoundingBox().func_72314_b(1.0, 0.0, 1.0) : super.getRenderBoundingBox();
    }
}

