/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.accelerator;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import nuclearscience.common.entity.EntityParticle;
import nuclearscience.common.inventory.container.ContainerParticleInjector;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.Voltaic;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;
import voltaic.prefab.utilities.object.Location;

public class TileParticleInjector
extends GenericTile {
    public static final int INPUT_SLOT = 0;
    public static final int ELECTRO_CELL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    public final EntityParticle[] particles = new EntityParticle[2];
    public int timeSinceSpawn = 0;
    public final SingleProperty<Boolean> usingGateway = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "usinggateway", (Object)false));
    public final SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasredstonesignal", (Object)false));

    public TileParticleInjector() {
        super((TileEntityType)NuclearScienceTiles.TILE_PARTICLEINJECTOR.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickCommon(this::tickCommon));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(2).outputs(1)).valid((index, stack, i) -> index != 1 || stack.func_77973_b() == NuclearScienceItems.ITEM_CELLELECTROMAGNETIC.get()).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1}).setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, new Integer[]{0, 1}).setDirectionsBySlot(Integer.valueOf(2), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT}));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(960.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).maxJoules(NuclearConstants.PARTICLEINJECTOR_USAGE_PER_PARTICLE));
        this.addComponent((IComponent)new ComponentContainerProvider("particleinjector", (GenericTile)this).createMenu((id, player) -> new ContainerParticleInjector((int)id, (PlayerInventory)player, (IInventory)this.getComponent(IComponentType.Inventory), this.getCoordsArray())));
    }

    private void tickCommon(ComponentTickable tickable) {
        if (this.particles[0] != null && !this.particles[0].func_70089_S()) {
            this.particles[0] = null;
        }
        if (this.particles[1] != null && !this.particles[1].func_70089_S()) {
            this.particles[1] = null;
        }
        if (this.particles[0] == null && this.particles[1] != null) {
            this.particles[0] = this.particles[1];
            this.particles[1] = null;
        }
    }

    private void tickServer(ComponentTickable componentTickable) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            return;
        }
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)((ComponentInventory)this.getComponent(IComponentType.Inventory)), (int)NuclearConstants.PARTICLE_INJECTOR_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)true, (boolean)false);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = inv.func_70301_a(0);
        if (electro.getJoulesStored() < NuclearConstants.PARTICLEINJECTOR_USAGE_PER_PARTICLE || input.func_190926_b()) {
            return;
        }
        if (this.timeSinceSpawn > 0) {
            --this.timeSinceSpawn;
            return;
        }
        if (((Boolean)this.usingGateway.getValue()).booleanValue() && this.particles[0] != null && !this.particles[0].passedThroughGate) {
            return;
        }
        if (!((Boolean)this.usingGateway.getValue()).booleanValue() && !this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.getFacing())).func_203425_a((Block)NuclearScienceBlocks.BLOCK_ELECTORMAGNETICBOOSTER.get())) {
            return;
        }
        if (this.particles[0] != null && this.particles[1] != null) {
            return;
        }
        ItemStack resultStack = inv.func_70301_a(2);
        if (resultStack.func_190916_E() >= resultStack.func_77976_d()) {
            return;
        }
        this.timeSinceSpawn = NuclearConstants.DEFAULT_PARTICLE_COOLDOWN_TICKS;
        input.func_190918_g(1);
        Direction dir = this.getFacing();
        EntityParticle particle = new EntityParticle(dir, this.field_145850_b, new Location((double)((float)this.field_174879_c.func_177958_n() + 0.5f + (float)dir.func_82601_c()), (double)((float)this.field_174879_c.func_177956_o() + 0.5f + (float)dir.func_96559_d()), (double)((float)this.field_174879_c.func_177952_p() + 0.5f + (float)dir.func_82599_e())), this.func_174877_v());
        this.addParticle(particle);
        this.field_145850_b.func_217376_c((Entity)particle);
        electro.setJoulesStored(electro.getJoulesStored() - NuclearConstants.PARTICLEINJECTOR_USAGE_PER_PARTICLE);
    }

    public boolean handleCollision() {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack resultStack = inv.func_70301_a(2);
        ItemStack cellStack = inv.func_70301_a(1);
        if (this.particles[0] == null || this.particles[1] == null) {
            return false;
        }
        EntityParticle one = this.particles[0];
        EntityParticle two = this.particles[1];
        if (one.func_70032_d(two) >= 1.0f) {
            return false;
        }
        BlockPos pos = one.func_233580_cy_();
        if (!this.field_145850_b.func_201670_d()) {
            this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 1.0f, 1.0f);
            one.remove(false);
            two.remove(false);
            Random random = Voltaic.RANDOM;
            for (int i = 0; i < 50; ++i) {
                double d0 = (double)pos.func_177958_n() + random.nextDouble();
                double d1 = (double)pos.func_177956_o() + random.nextDouble();
                double d2 = (double)pos.func_177952_p() + random.nextDouble();
                double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, 1, 0.0, 0.0, 0.0, d3);
            }
            if (!cellStack.func_190926_b() && resultStack.func_190916_E() < resultStack.func_77976_d() && one.speed >= 1.0f && two.speed >= 1.0f) {
                double speedOfMax = Math.pow((double)(one.speed + two.speed) / 4.0, 2.0);
                if (speedOfMax > 0.999) {
                    if (resultStack.func_77973_b() == NuclearScienceItems.ITEM_CELLDARKMATTER.get()) {
                        resultStack.func_190920_e(resultStack.func_190916_E() + 1);
                        cellStack.func_190918_g(1);
                    } else if (resultStack.func_190926_b()) {
                        inv.func_70299_a(2, new ItemStack((IItemProvider)NuclearScienceItems.ITEM_CELLDARKMATTER.get()));
                        cellStack.func_190918_g(1);
                    }
                } else if (speedOfMax > this.field_145850_b.field_73012_v.nextDouble()) {
                    if (resultStack.func_77973_b() == NuclearScienceItems.ITEM_CELLANTIMATTERSMALL.get()) {
                        resultStack.func_190920_e(resultStack.func_190916_E() + 1);
                        cellStack.func_190918_g(1);
                    } else if (resultStack.func_190926_b()) {
                        inv.func_70299_a(2, new ItemStack((IItemProvider)NuclearScienceItems.ITEM_CELLANTIMATTERSMALL.get()));
                        cellStack.func_190918_g(1);
                    }
                }
            }
            this.particles[1] = null;
            this.particles[0] = null;
        }
        return true;
    }

    public void addParticle(EntityParticle particle) {
        if (this.particles[0] == null && this.particles[1] == null) {
            this.particles[0] = particle;
        }
        if (this.particles[0] != null) {
            if (this.particles[0].func_110124_au().equals(particle.func_110124_au())) {
                return;
            }
            if (this.particles[1] == null) {
                this.particles[1] = particle;
            }
        }
        if (this.particles[1] != null) {
            if (this.particles[1].func_110124_au().equals(particle.func_110124_au())) {
                return;
            }
            if (this.particles[0] == null) {
                this.particles[0] = particle;
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("timesincespawn", this.timeSinceSpawn);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.timeSinceSpawn = compound.func_74762_e("timesincespawn");
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (!this.field_145850_b.func_201670_d()) {
            this.hasRedstoneSignal.setValue((Object)this.field_145850_b.func_175640_z(this.func_174877_v()));
        }
    }
}

