/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.fission;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import nuclearscience.api.turbine.ISteamReceiver;
import nuclearscience.common.block.BlockMeltedReactor;
import nuclearscience.common.inventory.container.ContainerFissionReactorCore;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.reactor.fission.IFissionControlRod;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceRecipies;
import nuclearscience.registers.NuclearScienceSounds;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.categories.item2item.Item2ItemRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.registers.VoltaicDamageTypes;

public class TileFissionReactorCore
extends GenericTile {
    public static final int FUEL_ROD_COUNT = 4;
    public static final int DUETERIUM_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;
    public static final int MELTDOWN_TEMPERATURE_ACTUAL = 5611;
    public static final int MELTDOWN_TEMPERATURE_CALC = 4407;
    public static final double WATER_TEMPERATURE = 10.0;
    public static final double AIR_TEMPERATURE = 15.0;
    public static final int STEAM_GEN_DIAMETER = 5;
    public static final int STEAM_GEN_HEIGHT = 2;
    private ISteamReceiver[][][] cachedReceivers = new ISteamReceiver[5][2][5];
    public SingleProperty<Double> temperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "temperature", (Object)15.0));
    public SingleProperty<Integer> fuelCount = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fuelCount", (Object)0));
    public SingleProperty<Boolean> hasDeuterium = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasDeuterium", (Object)false));
    private CachedTileOutput controlRodCache;
    private int ticksOverheating = 0;
    private List<VoltaicRecipe> cachedRecipes;

    public TileFissionReactorCore() {
        super((TileEntityType)NuclearScienceTiles.TILE_REACTORCORE.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickCommon(this::tickCommon).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(5).outputs(1)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1, 2, 3, 4}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BOTTOM, new Integer[]{5}));
        this.addComponent((IComponent)new ComponentContainerProvider("reactorcore", (GenericTile)this).createMenu((id, player) -> new ContainerFissionReactorCore((int)id, (PlayerInventory)player, (IInventory)this.getComponent(IComponentType.Inventory), this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        boolean hasWater;
        double decrease = ((Double)this.temperature.getValue() - 15.0) / 3000.0;
        if ((Integer)this.fuelCount.getValue() == 0) {
            decrease *= 25.0;
        }
        boolean bl = hasWater = !this.func_195044_w().func_204520_s().func_206888_e();
        if (hasWater) {
            decrease += ((Double)this.temperature.getValue() - 10.0) / 5000.0;
        }
        if (decrease != 0.0) {
            this.temperature.setValue((Object)((Double)this.temperature.getValue() - (decrease < 0.001 && decrease > 0.0 ? 0.001 : (decrease > -0.001 && decrease < 0.0 ? -0.001 : decrease))));
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        if ((Integer)this.fuelCount.getValue() > 0) {
            double totstrength = (Double)this.temperature.getValue() * 10.0;
            int range = (int)(Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0);
            RadiationSystem.addRadiationSource((World)this.func_145831_w(), (SimpleRadiationSource)new SimpleRadiationSource(totstrength, 1.0, range, true, 1, this.func_174877_v(), true, false));
            if (this.field_145850_b.func_201674_k().nextFloat() < 0.01f) {
                SoundEvent sound;
                switch (this.field_145850_b.field_73012_v.nextInt(6)) {
                    case 1: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_2.get();
                        break;
                    }
                    case 2: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_3.get();
                        break;
                    }
                    case 3: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_4.get();
                        break;
                    }
                    case 4: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_5.get();
                        break;
                    }
                    case 5: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_6.get();
                        break;
                    }
                    default: {
                        sound = (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_1.get();
                    }
                }
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (this.field_145850_b.func_72912_H().func_82573_f() % 10L == 0L && (Double)this.temperature.getValue() > 100.0) {
                AxisAlignedBB bb = AxisAlignedBB.func_241550_g_((double)4.0, (double)4.0, (double)4.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
                List list = this.field_145850_b.func_217357_a(LivingEntity.class, bb);
                for (LivingEntity living : list) {
                    if (!this.field_145850_b.func_180495_p(living.func_233580_cy_()).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    living.func_70097_a(DamageSource.field_76369_e, 3.0f);
                }
            }
            if (this.controlRodCache == null) {
                this.controlRodCache = new CachedTileOutput(this.func_145831_w(), this.field_174879_c.func_177977_b());
            }
            if (tickable.getTicks() % 10L == 0L && !this.controlRodCache.valid()) {
                this.controlRodCache.update(this.field_174879_c.func_177977_b());
            }
            int insertion = 0;
            if (this.controlRodCache.valid() && this.controlRodCache.getSafe() instanceof IFissionControlRod) {
                insertion = ((IFissionControlRod)this.controlRodCache.getSafe()).getInsertion();
            }
            double insertDecimal = 1.0 - (double)insertion / 100.0;
            if ((double)this.field_145850_b.field_73012_v.nextFloat() < insertDecimal) {
                for (int slot = 0; slot < 4; ++slot) {
                    ItemStack fuelRod = inv.func_70301_a(slot);
                    fuelRod.func_196085_b((int)((long)(fuelRod.func_77952_i() + 1) + Math.round((Double)this.temperature.getValue()) / 4407L));
                    if (fuelRod.func_190926_b() || fuelRod.func_77952_i() < fuelRod.func_77958_k()) continue;
                    inv.func_70299_a(slot, new ItemStack((IItemProvider)NuclearScienceItems.ITEM_FUELSPENT.get()));
                }
            }
            this.temperature.setValue((Object)((Double)this.temperature.getValue() + (4407.0 * insertDecimal * (0.25 * ((double)((Integer)this.fuelCount.getValue()).intValue() / 2.0) + this.field_145850_b.field_73012_v.nextDouble() / 5.0) - (Double)this.temperature.getValue()) / (200.0 + 20.0 * (hasWater ? 4.0 : 1.0))));
            if ((Double)this.temperature.getValue() > (double)(5611 + this.field_145850_b.field_73012_v.nextInt(50)) && (Integer)this.fuelCount.getValue() > 0) {
                ++this.ticksOverheating;
                if (this.ticksOverheating > 200) {
                    this.meltdown();
                }
            }
        } else {
            this.ticksOverheating = 0;
        }
        this.temperature.setValue((Object)Math.max(15.0, (Double)this.temperature.getValue()));
        if (((Boolean)this.hasDeuterium.getValue()).booleanValue() && (Integer)this.fuelCount.getValue() > 0 && (double)this.field_145850_b.field_73012_v.nextFloat() < 1.0 / (5288400.0 / (Double)this.temperature.getValue())) {
            this.processFissReact(inv);
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        if (tickable.getTicks() % 20L == 0L) {
            this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
        }
        this.produceSteam();
    }

    public void meltdown() {
        int radius = 2;
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPos ppos = new BlockPos(this.field_174879_c.func_177958_n() + i, this.field_174879_c.func_177956_o() + j, this.field_174879_c.func_177952_p() + k);
                    BlockState state = this.field_145850_b.func_180495_p(ppos);
                    if (state.func_177230_c() != Blocks.field_150355_j) continue;
                    this.field_145850_b.func_175656_a(ppos, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
        Explosion actual = new Explosion(this.field_145850_b, null, VoltaicDamageTypes.RADIATION, null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0f, true, Explosion.Mode.NONE);
        radius = 3 * (Integer)this.fuelCount.getValue();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    double distance;
                    BlockPos ppos = new BlockPos(this.field_174879_c.func_177958_n() + i, this.field_174879_c.func_177956_o() + j, this.field_174879_c.func_177952_p() + k);
                    BlockState state = this.field_145850_b.func_180495_p(ppos);
                    if (!(state.func_177230_c().getExplosionResistance(state, (IBlockReader)this.field_145850_b, ppos, actual) < (float)radius) || !((distance = Math.sqrt(i * i + j * j + k * k)) < (double)radius) || !((double)this.field_145850_b.field_73012_v.nextFloat() < 1.0 - 1.0E-4 * distance * distance * distance) || !((double)this.field_145850_b.field_73012_v.nextFloat() < 0.9)) continue;
                    this.field_145850_b.func_180495_p(ppos).onBlockExploded(this.field_145850_b, ppos, actual);
                }
            }
        }
        this.field_145850_b.func_217385_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0f, Explosion.Mode.BREAK);
        this.field_145850_b.func_175656_a(this.field_174879_c, ((BlockMeltedReactor)NuclearScienceBlocks.BLOCK_MELTEDREACTOR.get()).func_176223_P());
    }

    protected void produceSteam() {
        if ((Double)this.temperature.getValue() <= 400.0) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5; ++k) {
                    boolean isFaceWater;
                    boolean isReactor2d;
                    boolean bl = isReactor2d = i - 2 == 0 && k - 2 == 0;
                    if (isReactor2d && j == 0) {
                        if (this.field_145850_b.field_72995_K || !((double)this.field_145850_b.field_73012_v.nextFloat() < (Double)this.temperature.getValue() / 4407000.0) || !this.field_145850_b.func_180495_p(this.field_174879_c).func_235901_b_((Property)BlockStateProperties.field_208198_y)) continue;
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    int offsetX = this.field_174879_c.func_177958_n() + i - 2;
                    int offsetY = this.field_174879_c.func_177956_o() + j;
                    int offsetZ = this.field_174879_c.func_177952_p() + k - 2;
                    BlockPos offpos = new BlockPos(offsetX, offsetY, offsetZ);
                    if (!TileFissionReactorCore.isStillWater(this.func_145831_w(), offpos)) continue;
                    boolean bl2 = isFaceWater = TileFissionReactorCore.isStillWater(this.field_145850_b, new BlockPos(offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())) || TileFissionReactorCore.isStillWater(this.field_145850_b, new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), offsetZ)) || isReactor2d;
                    if (!isFaceWater) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        ISteamReceiver turbine = this.cachedReceivers[i][j][k];
                        if (turbine != null) {
                            if (turbine.isStillValid()) {
                                this.cachedReceivers[i][j][k] = null;
                            }
                            double temp = (Double)this.temperature.getValue();
                            turbine.receiveSteam((int)temp, (int)(NuclearConstants.FISSIONREACTOR_MAXENERGYTARGET / (500.0 * (5611.0 / (Double)this.temperature.getValue()))));
                        }
                        if ((double)this.field_145850_b.field_73012_v.nextFloat() < (Double)this.temperature.getValue() / 4407000.0) {
                            this.field_145850_b.func_175656_a(offpos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (turbine != null && !turbine.isStillValid()) continue;
                        TileEntity above = this.field_145850_b.func_175625_s(new BlockPos(offsetX, offsetY + 1, offsetZ));
                        if (above instanceof ISteamReceiver) {
                            this.cachedReceivers[i][j][k] = (ISteamReceiver)above;
                            continue;
                        }
                        this.cachedReceivers[i][j][k] = null;
                        continue;
                    }
                    if (!this.field_145850_b.field_72995_K || !((double)this.field_145850_b.field_73012_v.nextFloat() < (Double)this.temperature.getValue() / 16833.0)) continue;
                    double offsetFX = (double)offsetX + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    double offsetFY = (double)offsetY + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    double offsetFZ = (double)offsetZ + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197612_e, offsetFX + 0.5, offsetFY + (double)0.2f, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                    if (this.field_145850_b.field_73012_v.nextInt(3) != 0) continue;
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void processFissReact(ComponentInventory inv) {
        ItemStack input = inv.func_70301_a(4);
        ItemStack output = inv.func_70301_a(5);
        if (input.func_190926_b()) {
            return;
        }
        if (this.cachedRecipes == null || this.cachedRecipes.isEmpty()) {
            this.cachedRecipes = VoltaicRecipe.findRecipesbyType(NuclearScienceRecipies.FISSION_REACTOR_TYPE, (World)this.field_145850_b);
        }
        for (VoltaicRecipe iRecipe : this.cachedRecipes) {
            Item2ItemRecipe recipe = (Item2ItemRecipe)iRecipe;
            for (CountableIngredient ing : recipe.getCountedIngredients()) {
                if (!ing.test(input)) continue;
                if (output.func_190926_b()) {
                    inv.func_70299_a(5, recipe.getItemRecipeOutput().func_77946_l());
                    input.func_190918_g(((CountableIngredient)recipe.getCountedIngredients().get(0)).getStackSize());
                    continue;
                }
                if (output.func_190916_E() > output.func_77976_d() + recipe.getItemRecipeOutput().func_190916_E()) continue;
                output.func_190917_f(recipe.getItemRecipeOutput().func_190916_E());
                input.func_190918_g(((CountableIngredient)recipe.getCountedIngredients().get(0)).getStackSize());
            }
        }
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (slot == -1 || slot < 4) {
            this.fuelCount.setValue((Object)0);
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                int fuelValue = 0;
                if (stack.func_77973_b() == NuclearScienceItems.ITEM_FUELLEUO2.get()) {
                    fuelValue = 2;
                } else if (stack.func_77973_b() == NuclearScienceItems.ITEM_FUELHEUO2.get()) {
                    fuelValue = 3;
                } else if (stack.func_77973_b() == NuclearScienceItems.ITEM_FUELPLUTONIUM.get()) {
                    fuelValue = 2;
                }
                this.fuelCount.setValue((Object)((Integer)this.fuelCount.getValue() + fuelValue));
            }
        }
        if (slot == -1 || slot == 4) {
            this.hasDeuterium.setValue((Object)(!inv.func_70301_a(4).func_190926_b() ? 1 : 0));
        }
    }

    public static boolean isStillWater(World world, BlockPos pos) {
        FluidState fluidState = world.func_204610_c(pos);
        return fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && fluidState.func_206889_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("ticksoverheating", this.ticksOverheating);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.ticksOverheating = compound.func_74762_e("ticksoverheating");
    }

    public static double getActualTemp(double temperature) {
        return temperature / 4.0 + 15.0;
    }
}

