/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.fission;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import nuclearscience.common.block.BlockIrradiated;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileMeltedReactor
extends GenericTile {
    public static final float RADIATION_RADIUS = 30.0f;
    public static final float START_RADIATION = 4.383E7f;
    public int radiation = 43830000;
    public int temperature = 6000;

    public TileMeltedReactor() {
        super((TileEntityType)NuclearScienceTiles.TILE_MELTEDREACTOR.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
    }

    protected void tickServer(ComponentTickable tickable) {
        BlockState state;
        BlockPos pos;
        double distanceSq;
        double d5;
        double d4;
        double d3;
        double z2;
        double y2;
        BlockState state2;
        long ticks = tickable.getTicks();
        if (ticks % 3L == 0L && ((state2 = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())).isAir((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b()) || state2.func_177230_c() instanceof FlowingFluidBlock)) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), this.func_195044_w());
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (tile instanceof TileMeltedReactor) {
                ((TileMeltedReactor)tile).radiation = this.radiation;
            }
            return;
        }
        if (this.temperature > 0) {
            --this.temperature;
            double x2 = (double)this.field_174879_c.func_177958_n() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            y2 = (double)this.field_174879_c.func_177956_o() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            z2 = (double)this.field_174879_c.func_177952_p() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            d3 = (double)this.field_174879_c.func_177958_n() - x2;
            distanceSq = d3 * d3 + (d4 = (double)this.field_174879_c.func_177956_o() - y2) * d4 + (d5 = (double)this.field_174879_c.func_177952_p() - z2) * d5;
            if (distanceSq < 900.0 && this.field_145850_b.field_73012_v.nextDouble() > distanceSq / 900.0) {
                pos = new BlockPos((int)Math.floor(x2), (int)Math.floor(y2), (int)Math.floor(z2));
                state = this.field_145850_b.func_180495_p(pos);
                if (state.isAir((IBlockReader)this.field_145850_b, pos)) {
                    if (!this.field_145850_b.func_180495_p(pos.func_177977_b()).isAir((IBlockReader)this.field_145850_b, pos.func_177977_b())) {
                        this.field_145850_b.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    }
                } else if (state.func_235714_a_((ITag)BlockTags.field_242172_aH)) {
                    if (this.temperature > 2100) {
                        this.field_145850_b.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
                    }
                } else if (state.func_235714_a_((ITag)Tags.Blocks.COBBLESTONE)) {
                    this.field_145850_b.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
                } else if (this.field_145850_b.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    this.field_145850_b.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                } else if (state.func_235714_a_((ITag)BlockTags.field_203436_u)) {
                    this.field_145850_b.func_175656_a(pos, Blocks.field_150359_w.func_176223_P());
                }
            }
        }
        if (this.radiation > 0) {
            --this.radiation;
            double x2 = (double)this.field_174879_c.func_177958_n() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            y2 = (double)this.field_174879_c.func_177956_o() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            z2 = (double)this.field_174879_c.func_177952_p() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            d3 = (double)this.field_174879_c.func_177958_n() - x2;
            distanceSq = d3 * d3 + (d4 = (double)this.field_174879_c.func_177956_o() - y2) * d4 + (d5 = (double)this.field_174879_c.func_177952_p() - z2) * d5;
            if (distanceSq < 900.0 && this.field_145850_b.field_73012_v.nextDouble() > distanceSq / 900.0 && BlockIrradiated.isValidPlacement(state = this.field_145850_b.func_180495_p(pos = new BlockPos((int)Math.floor(x2), (int)Math.floor(y2), (int)Math.floor(z2))))) {
                this.field_145850_b.func_175656_a(pos, BlockIrradiated.getIrradiatedBlockstate(state));
            }
        }
        double totstrength = 120000.0f * ((float)this.radiation / 4.383E7f);
        int range = (int)(Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0);
        RadiationSystem.addRadiationSource((World)this.func_145831_w(), (SimpleRadiationSource)new SimpleRadiationSource(totstrength, 1.0, range, true, 1, this.func_174877_v(), true, false));
    }

    public ActionResultType use(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("rads", this.radiation);
        compound.func_74768_a("temp", this.temperature);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.radiation = compound.func_74762_e("rads");
        this.temperature = compound.func_74762_e("temp");
        super.func_230337_a_(state, compound);
    }
}

