/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.fusion;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import nuclearscience.common.block.BlockPlasma;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.reactor.fusion.TilePlasma;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileFusionReactorCore
extends GenericTile {
    public final SingleProperty<Integer> deuterium = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "deuterium", (Object)0));
    public final SingleProperty<Integer> tritium = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "tritium", (Object)0));
    public final SingleProperty<Integer> timeLeft = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "timeleft", (Object)0));

    public TileFusionReactorCore() {
        super((TileEntityType)NuclearScienceTiles.TILE_FUSIONREACTORCORE.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules(NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK * 20.0).voltage(480.0));
    }

    public void tickServer(ComponentTickable tick) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if ((Integer)this.tritium.getValue() > 0 && (Integer)this.deuterium.getValue() > 0 && (Integer)this.timeLeft.getValue() <= 0 && electro.getJoulesStored() > NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK) {
            this.deuterium.setValue((Object)((Integer)this.deuterium.getValue() - 1));
            this.tritium.setValue((Object)((Integer)this.tritium.getValue() - 1));
            this.timeLeft.setValue((Object)300);
        }
        if ((Integer)this.timeLeft.getValue() <= 0) {
            if (BlockEntityUtils.isLit((GenericTile)this)) {
                BlockEntityUtils.updateLit((GenericTile)this, (Boolean)false);
            }
            return;
        }
        if (!BlockEntityUtils.isLit((GenericTile)this)) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)true);
        }
        this.timeLeft.setValue((Object)((Integer)this.timeLeft.getValue() - 1));
        if (electro.getJoulesStored() < NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK) {
            return;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos offset = this.field_174879_c.func_177972_a(dir);
            BlockState offsetState = this.field_145850_b.func_180495_p(offset);
            if (offsetState.func_177230_c() == NuclearScienceBlocks.BLOCK_PLASMA.get()) {
                TileEntity tile = this.field_145850_b.func_175625_s(offset);
                if (!(tile instanceof TilePlasma) || (Integer)((TilePlasma)tile).ticksExisted.getValue() <= 30) continue;
                ((TilePlasma)tile).ticksExisted.setValue((Object)0);
                continue;
            }
            if (!offsetState.isAir((IBlockReader)this.field_145850_b, offset)) continue;
            this.field_145850_b.func_175656_a(offset, ((BlockPlasma)NuclearScienceBlocks.BLOCK_PLASMA.get()).func_176223_P());
        }
        electro.joules(electro.getJoulesStored() - NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK);
    }

    public ActionResultType use(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack inHand = player.func_184586_b(hand);
        int accepted = 0;
        if (inHand.func_77973_b().func_206844_a(NuclearScienceTags.Items.CELL_DEUTERIUM)) {
            accepted = this.addDeuteriumCells(inHand.func_190916_E());
        } else if (inHand.func_77973_b().func_206844_a(NuclearScienceTags.Items.CELL_TRITIUM)) {
            accepted = this.addTritiumCells(inHand.func_190916_E());
        }
        if (accepted > 0) {
            if (!this.field_145850_b.func_201670_d()) {
                inHand.func_190920_e(inHand.func_190916_E() - accepted);
            }
            return ActionResultType.CONSUME;
        }
        return super.use(player, hand, hit);
    }

    public int addDeuteriumCells(int count) {
        return this.addCell(this.deuterium, count);
    }

    public int addTritiumCells(int count) {
        return this.addCell(this.tritium, count);
    }

    private int addCell(SingleProperty<Integer> property, int count) {
        if ((Integer)property.getValue() >= NuclearConstants.FUSIONREACTOR_MAXSTORAGE) {
            return 0;
        }
        int added = Math.min(count, NuclearConstants.FUSIONREACTOR_MAXSTORAGE - (Integer)property.getValue());
        if (!this.field_145850_b.func_201670_d()) {
            property.setValue((Object)((Integer)property.getValue() + added));
        }
        return added;
    }

    public boolean isDeuteriumFull() {
        return (Integer)this.deuterium.getValue() >= NuclearConstants.FUSIONREACTOR_MAXSTORAGE;
    }

    public boolean isTritiumFull() {
        return (Integer)this.tritium.getValue() >= NuclearConstants.FUSIONREACTOR_MAXSTORAGE;
    }
}

