/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import nuclearscience.common.inventory.container.ContainerControlRodModule;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileInterfaceBound;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.registers.VoltaicItems;

public class TileControlRodModule
extends GenericTileInterfaceBound {
    private Direction relativeBack;
    public final SingleProperty<Integer> insertion = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "insertion", (Object)0));
    public final SingleProperty<Integer> redstoneSignal = ((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "redstonesignal", (Object)0))).onChange((prop, oldVal) -> {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || prop.getValue() == oldVal) {
            return;
        }
        double perc = (double)((Integer)prop.getValue()).intValue() / 15.0;
        double tot = perc * 100.0;
        int mult = (int)(tot / 10.0);
        this.insertion.setValue((Object)(mult * 10));
    });

    public TileControlRodModule() {
        super((TileEntityType)NuclearScienceTiles.TILE_CONTROLRODMODULE.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentContainerProvider("controlrodmodule", (GenericTile)this).createMenu((id, player) -> new ContainerControlRodModule((int)id, (PlayerInventory)player, (IInventory)new Inventory(0), this.getCoordsArray())));
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        if (this.relativeBack == null) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
        super.tickServer(tickable);
    }

    public void tickClient(ComponentTickable tickable) {
        if (this.relativeBack == null) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    @Override
    public boolean checkLinkedPosition(GenericTileInterface inter) {
        return ((BlockPos)inter.controlRodLocation.getValue()).equals((Object)this.func_174877_v());
    }

    @Override
    public Direction getCableLocation() {
        return this.relativeBack;
    }

    public void onBlockStateUpdate(BlockState oldState, BlockState newState) {
        super.onBlockStateUpdate(oldState, newState);
        if (!this.field_145850_b.func_201670_d() && oldState.func_235901_b_((Property)VoltaicBlockStates.FACING) && newState.func_235901_b_((Property)VoltaicBlockStates.FACING) && oldState.func_177229_b((Property)VoltaicBlockStates.FACING) != newState.func_177229_b((Property)VoltaicBlockStates.FACING)) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("relativeback", this.relativeBack.ordinal());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.relativeBack = Direction.values()[compound.func_74762_e("relativeback")];
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        super.onNeightborChanged(neighbor, blockStateTrigger);
        if (!this.field_145850_b.field_72995_K) {
            this.redstoneSignal.setValue((Object)this.func_145831_w().func_175687_A(this.func_174877_v()));
        }
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.field_145850_b.func_201670_d()) {
            if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
                return;
            }
            TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
            if (cable.func_145837_r()) {
                return;
            }
            ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
            GenericTileInterface inter = network.getInterface((BlockPos)this.interfaceLocation.getValue());
            if (inter == null) {
                return;
            }
            inter.controlRodLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        }
    }

    @Override
    public GenericTileInterface.InterfaceType[] getValidInterfaces() {
        return CONTROL_RODS;
    }

    public ActionResultType use(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_184586_b(hand).func_77973_b() == VoltaicItems.ITEM_WRENCH.get() && this.hasComponent(IComponentType.ContainerProvider)) {
            if (!this.field_145850_b.field_72995_K) {
                player.func_213829_a((INamedContainerProvider)this.getComponent(IComponentType.ContainerProvider));
                player.func_195066_a(Stats.field_188061_aa);
            }
            return ActionResultType.CONSUME;
        }
        if (this.field_145850_b.func_201670_d()) {
            return ActionResultType.CONSUME;
        }
        if (player.func_225608_bj_()) {
            this.insertion.setValue((Object)((Integer)this.insertion.getValue() - 10));
            if ((Integer)this.insertion.getValue() < 0) {
                this.insertion.setValue((Object)100);
            }
        } else {
            this.insertion.setValue((Object)((Integer)this.insertion.getValue() + 10));
            if ((Integer)this.insertion.getValue() > 100) {
                this.insertion.setValue((Object)0);
            }
        }
        return ActionResultType.CONSUME;
    }

    public int getComparatorSignal() {
        return (int)((double)((Integer)this.insertion.getValue()).intValue() / 100.0 * 15.0);
    }

    @Override
    public void onInterfacePropChange(SingleProperty<BlockPos> prop, BlockPos old) {
        GenericTileInterface inter;
        super.onInterfacePropChange(prop, old);
        boolean oldInval = old.equals((Object)BlockEntityUtils.OUT_OF_REACH);
        boolean newInval = ((BlockPos)prop.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH);
        if (oldInval && newInval) {
            return;
        }
        if (this.networkCable == null || !this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.func_145837_r()) {
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (oldInval && !newInval) {
            GenericTileInterface inter2 = network.getInterface((BlockPos)prop.getValue());
            if (inter2 != null) {
                inter2.controlRodLocation.setValue((Object)this.func_174877_v());
            }
        } else if (!oldInval && newInval && (inter = network.getInterface(old)) != null) {
            inter.controlRodLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        }
    }
}

