/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileLogisticsMember;
import nuclearscience.registers.NuclearScienceSounds;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileController
extends GenericTileLogisticsMember
implements ITickableSound {
    public static final double USAGE = 100.0;
    public final SingleProperty<Boolean> active = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "active", (Object)false));
    private Direction relativeBack;
    private boolean isSoundPlaying = false;

    public TileController() {
        super((TileEntityType)NuclearScienceTiles.TILE_LOGISTICSCONTROLLER.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(120.0).maxJoules(2000.0));
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        boolean canRun;
        if (this.relativeBack == null) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
        super.tickServer(tickable);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        boolean bl = canRun = electro.getJoulesStored() >= 100.0;
        if (BlockEntityUtils.isLit((GenericTile)this) ^ canRun) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)canRun);
        }
        if (canRun) {
            electro.setJoulesStored(electro.getJoulesStored() - 100.0);
            this.active.setValue((Object)canRun);
        }
    }

    public void tickClient(ComponentTickable tickable) {
        if (this.relativeBack == null) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
        if (!this.isSoundPlaying && this.shouldPlaySound()) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)NuclearScienceSounds.SOUND_LOGISTICSCONTROLLER.get()), (TileEntity)this, (boolean)true);
        }
    }

    @Override
    public Direction getCableLocation() {
        return this.relativeBack;
    }

    @Override
    public boolean canConnect(ReactorLogisticsNetwork network) {
        return network.getController() == null || network.getController().func_174877_v().equals((Object)this.func_174877_v());
    }

    public void onBlockStateUpdate(BlockState oldState, BlockState newState) {
        super.onBlockStateUpdate(oldState, newState);
        if (!this.field_145850_b.func_201670_d() && oldState.func_235901_b_((Property)VoltaicBlockStates.FACING) && newState.func_235901_b_((Property)VoltaicBlockStates.FACING) && oldState.func_177229_b((Property)VoltaicBlockStates.FACING) != newState.func_177229_b((Property)VoltaicBlockStates.FACING)) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("relativeback", this.relativeBack.ordinal());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.relativeBack = Direction.values()[compound.func_74762_e("relativeback")];
    }

    public boolean isActive() {
        return (Boolean)this.active.getValue();
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.active.getValue();
    }
}

