/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import nuclearscience.common.inventory.container.ContainerSupplyModule;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileInterfaceBound;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileSupplyModule
extends GenericTileInterfaceBound {
    private Direction relativeBack;

    public TileSupplyModule() {
        super((TileEntityType)NuclearScienceTiles.TILE_SUPPLYMODULE.get());
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(9).outputs(9)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8}).setSlotsByDirection(BlockEntityUtils.MachineDirection.FRONT, new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BOTTOM, new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17}).setSlotsByDirection(BlockEntityUtils.MachineDirection.LEFT, new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17}).setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17}).valid(TileSupplyModule.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider("supplymodule", (GenericTile)this).createMenu((id, player) -> new ContainerSupplyModule((int)id, (PlayerInventory)player, (IInventory)this.getComponent(IComponentType.Inventory), this.getCoordsArray())));
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        if (this.relativeBack == null) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
        super.tickServer(tickable);
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)((ComponentInventory)this.getComponent(IComponentType.Inventory)), (int)NuclearConstants.RADIOACTIVE_PROCESSOR_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)true, (boolean)false);
    }

    public void tickClient(ComponentTickable tickable) {
        if (this.relativeBack == null) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    @Override
    public boolean checkLinkedPosition(GenericTileInterface inter) {
        return ((BlockPos)inter.supplyModuleLocation.getValue()).equals((Object)this.func_174877_v());
    }

    @Override
    public GenericTileInterface.InterfaceType[] getValidInterfaces() {
        return SUPPLIES;
    }

    @Override
    public Direction getCableLocation() {
        return this.relativeBack;
    }

    public void onBlockStateUpdate(BlockState oldState, BlockState newState) {
        super.onBlockStateUpdate(oldState, newState);
        if (!this.field_145850_b.func_201670_d() && oldState.func_235901_b_((Property)VoltaicBlockStates.FACING) && newState.func_235901_b_((Property)VoltaicBlockStates.FACING) && oldState.func_177229_b((Property)VoltaicBlockStates.FACING) != newState.func_177229_b((Property)VoltaicBlockStates.FACING)) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("relativeback", this.relativeBack.ordinal());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.relativeBack = Direction.values()[compound.func_74762_e("relativeback")];
    }

    @Override
    public void onInterfacePropChange(SingleProperty<BlockPos> prop, BlockPos old) {
        GenericTileInterface inter;
        super.onInterfacePropChange(prop, old);
        boolean oldInval = old.equals((Object)BlockEntityUtils.OUT_OF_REACH);
        boolean newInval = ((BlockPos)prop.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH);
        if (oldInval && newInval) {
            return;
        }
        if (this.networkCable == null || !this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.func_145837_r()) {
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (oldInval && !newInval) {
            GenericTileInterface inter2 = network.getInterface((BlockPos)prop.getValue());
            if (inter2 != null) {
                inter2.supplyModuleLocation.setValue((Object)this.func_174877_v());
            }
        } else if (!oldInval && newInval && (inter = network.getInterface(old)) != null) {
            inter.supplyModuleLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        }
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.field_145850_b.func_201670_d()) {
            if (this.networkCable == null || !this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
                return;
            }
            TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
            if (cable.func_145837_r()) {
                return;
            }
            ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
            GenericTileInterface inter = network.getInterface((BlockPos)this.interfaceLocation.getValue());
            if (inter == null) {
                return;
            }
            inter.supplyModuleLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        }
    }
}

