/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import nuclearscience.common.inventory.container.ContainerThermometerModule;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileInterfaceBound;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileThermometerModule
extends GenericTileInterfaceBound {
    private Direction relativeBack;
    public final SingleProperty<Integer> mode = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "comparitormode", (Object)Mode.CONSTANT.ordinal()));
    public final SingleProperty<Boolean> inverted = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "inverted", (Object)false));
    public final SingleProperty<Double> targetTemperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "targettemperature", (Object)0.0));
    public final SingleProperty<Double> trackedTemperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "trackedtemperature", (Object)0.0));
    public final SingleProperty<Integer> redstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "redstonesignal", (Object)0));
    public static final int MAX_REDSTONE = 15;

    public TileThermometerModule() {
        super((TileEntityType)NuclearScienceTiles.TILE_THERMOMETERMODULE.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentContainerProvider("thermometermodule", (GenericTile)this).createMenu((id, player) -> new ContainerThermometerModule((int)id, (PlayerInventory)player, (IInventory)new Inventory(0), this.getCoordsArray())));
    }

    public void tickClient(ComponentTickable tickable) {
        if (this.relativeBack == null) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        if (this.relativeBack == null) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
        super.tickServer(tickable);
        GenericTileInterface.InterfaceType type = GenericTileInterface.InterfaceType.values()[(Integer)this.interfaceType.getValue()];
        if (type == GenericTileInterface.InterfaceType.NONE || ((BlockPos)this.interfaceLocation.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.func_145837_r()) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (!network.isControllerActive()) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        GenericTileInterface genericInterface = network.getInterface((BlockPos)this.interfaceLocation.getValue());
        if (genericInterface == null || genericInterface.getInterfaceType() != type) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        if (genericInterface.reactor == null || !genericInterface.reactor.valid()) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        double temp = -1.0;
        TileEntity blockentity = (TileEntity)genericInterface.reactor.getSafe();
        if (blockentity instanceof TileFissionReactorCore) {
            temp = TileFissionReactorCore.getActualTemp((Double)((TileFissionReactorCore)blockentity).temperature.getValue());
        } else if (blockentity instanceof TileMSReactorCore) {
            temp = (Double)((TileMSReactorCore)blockentity).temperature.getValue();
        }
        if (temp < 0.0) {
            this.redstoneSignal.setValue((Object)0);
            this.trackedTemperature.setValue((Object)0.0);
            return;
        }
        double perc = 0.0;
        this.trackedTemperature.setValue((Object)temp);
        switch (Mode.values()[(Integer)this.mode.getValue()]) {
            case CONSTANT: {
                if (((Boolean)this.inverted.getValue()).booleanValue()) {
                    if (temp <= (Double)this.targetTemperature.getValue()) {
                        perc = 1.0;
                        break;
                    }
                    perc = 0.0;
                    break;
                }
                if (temp >= (Double)this.targetTemperature.getValue()) {
                    perc = 1.0;
                    break;
                }
                perc = 0.0;
                break;
            }
            case BUILD_UP: {
                if (((Boolean)this.inverted.getValue()).booleanValue()) {
                    if (temp == 0.0 || (Double)this.targetTemperature.getValue() == 0.0) {
                        perc = 1.0;
                        break;
                    }
                    perc = 1.0 - Math.min(1.0, temp / (Double)this.targetTemperature.getValue());
                    break;
                }
                perc = temp == 0.0 || (Double)this.targetTemperature.getValue() == 0.0 ? 0.0 : Math.min(1.0, temp / (Double)this.targetTemperature.getValue());
            }
        }
        this.redstoneSignal.setValue((Object)((int)(15.0 * perc)));
    }

    @Override
    public boolean checkLinkedPosition(GenericTileInterface inter) {
        return true;
    }

    @Override
    public Direction getCableLocation() {
        return this.relativeBack;
    }

    public void onBlockStateUpdate(BlockState oldState, BlockState newState) {
        super.onBlockStateUpdate(oldState, newState);
        if (!this.field_145850_b.func_201670_d() && oldState.func_235901_b_((Property)VoltaicBlockStates.FACING) && newState.func_235901_b_((Property)VoltaicBlockStates.FACING) && oldState.func_177229_b((Property)VoltaicBlockStates.FACING) != newState.func_177229_b((Property)VoltaicBlockStates.FACING)) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("relativeback", this.relativeBack.ordinal());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.relativeBack = Direction.values()[compound.func_74762_e("relativeback")];
    }

    @Override
    public GenericTileInterface.InterfaceType[] getValidInterfaces() {
        return TEMPERATURE;
    }

    public int getComparatorSignal() {
        return (Integer)this.redstoneSignal.getValue();
    }

    public static enum Mode {
        BUILD_UP,
        CONSTANT;

    }
}

