/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork.interfaces;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.reactor.fission.IFissionControlRod;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileControlRodModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileSupplyModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileFissionInterface
extends GenericTileInterface
implements IFissionControlRod {
    public final SingleProperty<Integer> insertion = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "insertion", (Object)0));

    public TileFissionInterface() {
        super((TileEntityType)NuclearScienceTiles.TILE_FISSIONINTERFACE.get());
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        int j;
        ItemStack item;
        super.tickServer(tickable);
        if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            this.insertion.setValue((Object)0);
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.func_145837_r()) {
            this.insertion.setValue((Object)0);
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (!network.isControllerActive()) {
            this.insertion.setValue((Object)0);
            return;
        }
        TileControlRodModule controlRod = network.getControlRod((BlockPos)this.controlRodLocation.getValue());
        if (controlRod == null) {
            this.insertion.setValue((Object)0);
        } else {
            this.insertion.setValue(controlRod.insertion.getValue());
        }
        TileSupplyModule supplyModule = network.getSupplyModule((BlockPos)this.supplyModuleLocation.getValue());
        if (!this.reactor.valid() || supplyModule == null || !(this.reactor.getSafe() instanceof TileFissionReactorCore)) {
            return;
        }
        TileFissionReactorCore core = (TileFissionReactorCore)((Object)this.reactor.getSafe());
        ComponentInventory coreInv = (ComponentInventory)core.getComponent(IComponentType.Inventory);
        ComponentInventory supplyInv = (ComponentInventory)supplyModule.getComponent(IComponentType.Inventory);
        boolean isExtractingSpentCell = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_1) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_2) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_3) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_4);
        boolean isInsertingFuelCell = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_1) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_2) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_3) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_4);
        boolean isExtractingTritium = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_TRITIUM_EXTRACT);
        boolean isInsertingDeuterium = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_DEUTERIUM_INSERT);
        ItemStack deuterium = coreInv.func_70301_a(4);
        if (!isInsertingFuelCell) {
            for (int i = 0; i < 4; ++i) {
                item = coreInv.func_70301_a(i);
                if (item.func_190926_b() || !item.func_77973_b().func_206844_a(NuclearScienceTags.Items.FUELROD_SPENT)) continue;
                boolean inserted = false;
                for (j = 9; j < 18; ++j) {
                    if (!supplyInv.func_70301_a(j).func_190926_b()) continue;
                    supplyInv.func_70299_a(j, item.func_77946_l());
                    coreInv.func_70299_a(i, ItemStack.field_190927_a);
                    inserted = true;
                    break;
                }
                if (!inserted) continue;
                switch (i) {
                    case 0: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_1.ordinal());
                        break;
                    }
                    case 1: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_2.ordinal());
                        break;
                    }
                    case 2: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_3.ordinal());
                        break;
                    }
                    case 3: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_4.ordinal());
                    }
                }
                isExtractingSpentCell = true;
            }
        }
        if (!isInsertingDeuterium && !coreInv.areOutputsEmpty()) {
            item = coreInv.func_70301_a(5);
            boolean extracted = false;
            for (j = 9; j < 18 && !coreInv.areOutputsEmpty() && !item.func_190926_b(); ++j) {
                ItemStack destItem = supplyInv.func_70301_a(j);
                if (destItem.func_190926_b()) {
                    supplyInv.func_70299_a(j, item.func_77946_l());
                    coreInv.func_70299_a(5, ItemStack.field_190927_a);
                    extracted = true;
                    continue;
                }
                if (!destItem.func_77973_b().func_206844_a(NuclearScienceTags.Items.CELL_TRITIUM) || destItem.func_190916_E() >= destItem.func_77976_d()) continue;
                int taken = Math.min(destItem.func_77976_d() - destItem.func_190916_E(), item.func_190916_E());
                destItem.func_190917_f(taken);
                item.func_190918_g(taken);
                extracted = true;
            }
            if (extracted) {
                this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_TRITIUM_EXTRACT.ordinal());
                isExtractingTritium = true;
            }
        }
        if (!isExtractingSpentCell && !supplyInv.areInputsEmpty()) {
            block15: for (int i = 0; i < 4; ++i) {
                item = coreInv.func_70301_a(i);
                if (item.func_77973_b().func_206844_a(NuclearScienceTags.Items.FUELROD_URANIUM_LOW_EN) || item.func_77973_b().func_206844_a(NuclearScienceTags.Items.FUELROD_URANIUM_HIGH_EN) || item.func_77973_b().func_206844_a(NuclearScienceTags.Items.FUELROD_PLUTONIUM) || !item.func_190926_b()) continue;
                boolean inserted = false;
                for (int j2 = 0; j2 < 9; ++j2) {
                    ItemStack supplyItem = supplyInv.func_70301_a(j2);
                    if (!supplyItem.func_77973_b().func_206844_a(NuclearScienceTags.Items.FUELROD_URANIUM_LOW_EN) && !supplyItem.func_77973_b().func_206844_a(NuclearScienceTags.Items.FUELROD_URANIUM_HIGH_EN) && !supplyItem.func_77973_b().func_206844_a(NuclearScienceTags.Items.FUELROD_PLUTONIUM)) continue;
                    coreInv.func_70299_a(i, supplyItem.func_77946_l());
                    supplyInv.func_70299_a(j2, ItemStack.field_190927_a);
                    inserted = true;
                    break;
                }
                if (!inserted) continue;
                switch (i) {
                    case 0: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_1.ordinal());
                        continue block15;
                    }
                    case 1: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_2.ordinal());
                        continue block15;
                    }
                    case 2: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_3.ordinal());
                        continue block15;
                    }
                    case 3: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_4.ordinal());
                    }
                }
            }
        }
        if (!isExtractingTritium && (deuterium.func_190926_b() || deuterium.func_77973_b().func_206844_a(NuclearScienceTags.Items.CELL_DEUTERIUM) && deuterium.func_190916_E() < deuterium.func_77976_d())) {
            boolean taken = false;
            for (int j3 = 0; !(j3 >= 9 || (deuterium = coreInv.func_70301_a(4)).func_77973_b().func_206844_a(NuclearScienceTags.Items.CELL_DEUTERIUM) && deuterium.func_190916_E() >= deuterium.func_77976_d()); ++j3) {
                item = supplyInv.func_70301_a(j3).func_77946_l();
                if (!item.func_77973_b().func_206844_a(NuclearScienceTags.Items.CELL_DEUTERIUM)) continue;
                if (deuterium.func_190926_b()) {
                    coreInv.func_70299_a(4, item.func_77946_l());
                    supplyInv.func_70299_a(j3, ItemStack.field_190927_a);
                    taken = true;
                    continue;
                }
                if (deuterium.func_190916_E() >= deuterium.func_77976_d()) continue;
                int amt = Math.min(item.func_190916_E(), deuterium.func_77976_d() - deuterium.func_190916_E());
                supplyInv.func_70298_a(j3, amt);
                deuterium.func_190917_f(amt);
                taken = true;
            }
            if (taken) {
                this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_DEUTERIUM_INSERT.ordinal());
            }
        }
        this.handleServerAnimations(tickable);
    }

    @Override
    public int getInsertion() {
        return (Integer)this.insertion.getValue();
    }

    @Override
    public Direction getReactorDirection() {
        return Direction.UP;
    }

    @Override
    public GenericTileInterface.InterfaceType getInterfaceType() {
        return GenericTileInterface.InterfaceType.FISSION;
    }

    @Override
    public Direction getCableLocation() {
        return Direction.DOWN;
    }
}

