/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork.interfaces;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.reactor.fusion.TileFusionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileSupplyModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileFusionInterface
extends GenericTileInterface {
    public TileFusionInterface() {
        super((TileEntityType)NuclearScienceTiles.TILE_FUSIONINTERFACE.get());
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        int accepted;
        ItemStack stack;
        int i;
        boolean inserted;
        boolean checkTritium;
        super.tickServer(tickable);
        if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.func_145837_r()) {
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (!network.isControllerActive()) {
            return;
        }
        TileSupplyModule supplyModule = network.getSupplyModule((BlockPos)this.supplyModuleLocation.getValue());
        if (!this.reactor.valid() || supplyModule == null || !(this.reactor.getSafe() instanceof TileFusionReactorCore)) {
            return;
        }
        TileFusionReactorCore core = (TileFusionReactorCore)((Object)this.reactor.getSafe());
        ComponentInventory supplyInv = (ComponentInventory)supplyModule.getComponent(IComponentType.Inventory);
        boolean isInsertingTritium = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FUSION_TRITIUM_INSERT);
        boolean isInsertingDeuterium = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FUSION_DEUTERIUM_INSERT);
        boolean checkDeuterium = !core.isDeuteriumFull();
        boolean bl = checkTritium = !core.isTritiumFull();
        if (!checkDeuterium && !checkTritium) {
            this.handleServerAnimations(tickable);
            return;
        }
        if (!isInsertingTritium && checkDeuterium) {
            inserted = false;
            for (i = 0; i < 9; ++i) {
                stack = supplyInv.func_70301_a(i);
                if (stack.func_190926_b() || !stack.func_77973_b().func_206844_a(NuclearScienceTags.Items.CELL_DEUTERIUM)) continue;
                accepted = core.addDeuteriumCells(stack.func_190916_E());
                if (accepted > 0) {
                    supplyInv.func_70298_a(i, accepted);
                    inserted = true;
                    isInsertingDeuterium = true;
                }
                if (core.isDeuteriumFull()) break;
            }
            if (inserted) {
                this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FUSION_DEUTERIUM_INSERT.ordinal());
            }
        }
        if (!isInsertingDeuterium && checkTritium) {
            inserted = false;
            for (i = 0; i < 9; ++i) {
                stack = supplyInv.func_70301_a(i);
                if (stack.func_190926_b() || !stack.func_77973_b().func_206844_a(NuclearScienceTags.Items.CELL_TRITIUM)) continue;
                accepted = core.addTritiumCells(stack.func_190916_E());
                if (accepted > 0) {
                    supplyInv.func_70298_a(i, accepted);
                    inserted = true;
                }
                if (core.isTritiumFull()) break;
            }
            if (inserted) {
                this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FUSION_TRITIUM_INSERT.ordinal());
            }
        }
        this.handleServerAnimations(tickable);
    }

    @Override
    public Direction getReactorDirection() {
        return Direction.UP;
    }

    @Override
    public GenericTileInterface.InterfaceType getInterfaceType() {
        return GenericTileInterface.InterfaceType.FUSION;
    }

    @Override
    public Direction getCableLocation() {
        return Direction.DOWN;
    }
}

