/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import nuclearscience.api.network.reactorlogistics.Interface;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileLogisticsMember;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public abstract class GenericTileInterfaceBound
extends GenericTileLogisticsMember {
    public static final GenericTileInterface.InterfaceType[] CONTROL_RODS = new GenericTileInterface.InterfaceType[]{GenericTileInterface.InterfaceType.FISSION, GenericTileInterface.InterfaceType.MS};
    public static final GenericTileInterface.InterfaceType[] TEMPERATURE = new GenericTileInterface.InterfaceType[]{GenericTileInterface.InterfaceType.FISSION, GenericTileInterface.InterfaceType.MS};
    public static final GenericTileInterface.InterfaceType[] SUPPLIES = new GenericTileInterface.InterfaceType[]{GenericTileInterface.InterfaceType.FISSION, GenericTileInterface.InterfaceType.FUSION};
    public static final GenericTileInterface.InterfaceType[] ALL = new GenericTileInterface.InterfaceType[]{GenericTileInterface.InterfaceType.FISSION, GenericTileInterface.InterfaceType.MS, GenericTileInterface.InterfaceType.FUSION};
    public final SingleProperty<Boolean> linked = ((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "islinked", (Object)false))).onChange((prop, old) -> {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (BlockEntityUtils.isLit((GenericTile)this) ^ (Boolean)prop.getValue()) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)((Boolean)prop.getValue()));
        }
    });
    public final SingleProperty<BlockPos> interfaceLocation = ((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "interfacelocation", (Object)BlockEntityUtils.OUT_OF_REACH))).onChange((prop, old) -> {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.onInterfacePropChange((SingleProperty<BlockPos>)prop, (BlockPos)old);
    });
    public final SingleProperty<Integer> interfaceType = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "interfacetype", (Object)GenericTileInterface.InterfaceType.NONE.ordinal()));
    public final List<Interface> clientInterfaces = new ArrayList<Interface>();

    public GenericTileInterfaceBound(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        super.tickServer(tickable);
        if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            this.linked.setValue((Object)false);
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.func_145837_r()) {
            this.linked.setValue((Object)false);
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        GenericTileInterface inter = network.getInterface((BlockPos)this.interfaceLocation.getValue());
        if (!network.isControllerActive() || inter == null) {
            this.linked.setValue((Object)false);
            return;
        }
        if (inter.getInterfaceType() != GenericTileInterface.InterfaceType.values()[(Integer)this.interfaceType.getValue()] || !this.checkLinkedPosition(inter)) {
            this.interfaceLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
            this.interfaceType.setValue((Object)GenericTileInterface.InterfaceType.NONE.ordinal());
            this.linked.setValue((Object)false);
        }
        this.linked.setValue((Object)true);
    }

    public abstract boolean checkLinkedPosition(GenericTileInterface var1);

    public abstract GenericTileInterface.InterfaceType[] getValidInterfaces();

    public List<Interface> getInterfacesForClient() {
        if (this.networkCable == null || !this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            return Collections.emptyList();
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.func_145837_r()) {
            return Collections.emptyList();
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        List<GenericTileInterface> interfaces = network.getInterfacesForType(this.getValidInterfaces());
        ArrayList<Interface> list = new ArrayList<Interface>();
        interfaces.forEach(tile -> list.add(new Interface(tile.func_174877_v(), tile.getInterfaceType())));
        return list;
    }

    public void onInterfacePropChange(SingleProperty<BlockPos> prop, BlockPos old) {
    }
}

