/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.moltensalt;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import nuclearscience.api.turbine.ISteamReceiver;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.object.Location;

public class TileHeatExchanger
extends GenericTile {
    public static final int STEAM_GEN_DIAMETER = 5;
    public static final int STEAM_GEN_HEIGHT = 2;
    private ISteamReceiver[][][] cachedReceivers = new ISteamReceiver[5][2][5];
    public SingleProperty<Double> temperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "temperature", (Object)0.0));

    public TileHeatExchanger() {
        super((TileEntityType)NuclearScienceTiles.TILE_HEATEXCHANGER.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickCommon(this::tickCommon).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
    }

    private void tickServer(ComponentTickable componentTickable) {
        this.temperature.setValue((Object)((Double)this.temperature.getValue() * 0.9));
        if ((Double)this.temperature.getValue() > 100.0) {
            Location source = new Location((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f));
            AxisAlignedBB bb = AxisAlignedBB.func_241550_g_((double)4.0, (double)4.0, (double)4.0).func_72317_d(source.x(), source.y(), source.z());
            List list = this.field_145850_b.func_217357_a(LivingEntity.class, bb);
            for (LivingEntity living : list) {
                if (!this.field_145850_b.func_180495_p(living.func_233580_cy_()).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                living.func_70097_a(DamageSource.field_76369_e, 3.0f);
            }
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        if ((Double)this.temperature.getValue() > 100.0) {
            this.produceSteam();
        }
    }

    protected void produceSteam() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5; ++k) {
                    boolean isFaceWater;
                    boolean isReactor2d;
                    boolean bl = isReactor2d = i - 2 == 0 && k - 2 == 0;
                    if (isReactor2d && j == 0) {
                        if (this.field_145850_b.field_72995_K || !((double)this.field_145850_b.field_73012_v.nextFloat() < (Double)this.temperature.getValue() / 1000000.0) || !this.field_145850_b.func_180495_p(this.field_174879_c).func_235901_b_((Property)BlockStateProperties.field_208198_y)) continue;
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    int offsetX = this.field_174879_c.func_177958_n() + i - 2;
                    int offsetY = this.field_174879_c.func_177956_o() + j;
                    int offsetZ = this.field_174879_c.func_177952_p() + k - 2;
                    BlockPos offpos = new BlockPos(offsetX, offsetY, offsetZ);
                    if (!TileFissionReactorCore.isStillWater(this.func_145831_w(), offpos)) continue;
                    boolean bl2 = isFaceWater = TileFissionReactorCore.isStillWater(this.func_145831_w(), new BlockPos(offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())) || TileFissionReactorCore.isStillWater(this.func_145831_w(), new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), offsetZ)) || isReactor2d;
                    if (!isFaceWater) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        ISteamReceiver turbine = this.cachedReceivers[i][j][k];
                        if (turbine != null) {
                            if (turbine.isStillValid()) {
                                this.cachedReceivers[i][j][k] = null;
                            }
                            turbine.receiveSteam((int)(NuclearConstants.MSRREACTOR_MAXENERGYTARGET / (500.0 * (1000.0 / (Double)this.temperature.getValue()))), ((Double)this.temperature.getValue()).intValue());
                        }
                        if ((double)this.field_145850_b.field_73012_v.nextFloat() < (Double)this.temperature.getValue() / 1000000.0) {
                            this.field_145850_b.func_175656_a(offpos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (turbine != null && !turbine.isStillValid()) continue;
                        TileEntity above = this.field_145850_b.func_175625_s(new BlockPos(offsetX, offsetY + 1, offsetZ));
                        if (above instanceof ISteamReceiver) {
                            this.cachedReceivers[i][j][k] = (ISteamReceiver)above;
                            continue;
                        }
                        this.cachedReceivers[i][j][k] = null;
                        continue;
                    }
                    if (!this.field_145850_b.field_72995_K || !((double)this.field_145850_b.field_73012_v.nextFloat() < (Double)this.temperature.getValue() / 3000.0)) continue;
                    double offsetFX = (double)offsetX + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    double offsetFY = (double)offsetY + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    double offsetFZ = (double)offsetZ + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197612_e, offsetFX + 0.5, offsetFY + (double)0.2f, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                    if (this.field_145850_b.field_73012_v.nextInt(3) != 0) continue;
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public Double receiveHeat(Double perReceiver) {
        this.temperature.setValue((Object)perReceiver);
        return perReceiver;
    }

    public ActionResultType use(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }
}

