/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.moltensalt;

import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import nuclearscience.common.inventory.container.ContainerMoltenSaltSupplier;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileMoltenSaltSupplier
extends GenericTile {
    public static final double AMT_PER_SALT = 250.0;
    public static final double AMT_PER_WASTE = 300.0;
    protected CachedTileOutput output;
    public final SingleProperty<Double> reactorWaste = (SingleProperty)this.property(new SingleProperty(PropertyTypes.DOUBLE, "reactorwaste", (Object)0.0).setNoSave());

    public TileMoltenSaltSupplier() {
        super((TileEntityType)NuclearScienceTiles.TILE_MOLTENSALTSUPPLIER.get());
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(NuclearConstants.MOLTENSALTSUPPLIER_VOLTAGE).extractPower((x, y) -> TransferPack.EMPTY).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules(NuclearConstants.MOLTENSALTSUPPLIER_USAGE_PER_TICK * 20.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1).outputs(1)).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.TOP}).setDirectionsBySlot(Integer.valueOf(1), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).valid((slot, stack, i) -> stack.func_77973_b() == NuclearScienceItems.ITEM_LIFHT4PUF3.get()));
        this.addComponent((IComponent)new ComponentContainerProvider("moltensaltsupplier", (GenericTile)this).createMenu((id, player) -> new ContainerMoltenSaltSupplier((int)id, (PlayerInventory)player, (IInventory)this.getComponent(IComponentType.Inventory), this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro;
        boolean enoughPower;
        Direction dir = this.getFacing();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.field_145850_b, this.field_174879_c.func_177972_a(dir.func_176734_d()));
        }
        boolean bl = enoughPower = (electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).getJoulesStored() >= NuclearConstants.MOLTENSALTSUPPLIER_USAGE_PER_TICK;
        if (!enoughPower) {
            return;
        }
        if (BlockEntityUtils.isLit((GenericTile)this) ^ enoughPower) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)enoughPower);
        }
        electro.joules(electro.getJoulesStored() - NuclearConstants.MOLTENSALTSUPPLIER_USAGE_PER_TICK);
        if (tickable.getTicks() % 40L == 0L) {
            this.output.update(this.field_174879_c.func_177972_a(dir.func_176734_d()));
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack fuel = inv.func_70301_a(0);
        if (!this.output.valid() || !(this.output.getSafe() instanceof TileMSReactorCore)) {
            this.reactorWaste.setValue((Object)0.0);
            return;
        }
        TileMSReactorCore core = (TileMSReactorCore)((Object)this.output.getSafe());
        this.reactorWaste.setValue(core.currentWaste.getValue());
        if (fuel.func_190926_b()) {
            return;
        }
        if (core.getFacing() != dir) {
            return;
        }
        if (1000.0 - (Double)core.currentFuel.getValue() >= 250.0) {
            fuel.func_190918_g(1);
            core.currentFuel.setValue((Object)((Double)core.currentFuel.getValue() + 250.0));
        }
        if ((Double)core.currentWaste.getValue() < 300.0) {
            return;
        }
        ItemStack waste = inv.func_70301_a(1);
        if (waste.func_190916_E() >= waste.func_77976_d()) {
            return;
        }
        if (waste.func_190926_b()) {
            inv.func_70299_a(1, new ItemStack((IItemProvider)NuclearScienceItems.ITEM_FISSILE_SALT.get()));
        } else {
            waste.func_190917_f(1);
            inv.func_70299_a(1, waste);
        }
        core.currentWaste.setValue((Object)((Double)core.currentWaste.getValue() - 300.0));
    }
}

