/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.world;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class QuantumCapacitorData
extends WorldSavedData {
    public static final String DATANAME = "quantumcapacitordata";
    public HashMap<UUID, HashMap<Integer, Double>> powermapping = new HashMap();

    public QuantumCapacitorData() {
        super(DATANAME);
    }

    public void func_76184_a(CompoundNBT source) {
        this.powermapping.clear();
        ListNBT list = source.func_150295_c("list", 10);
        for (INBT en : list) {
            CompoundNBT compound = (CompoundNBT)en;
            UUID id = compound.func_186857_a("uuid");
            ListNBT entryList = compound.func_150295_c("entrylist", 10);
            HashMap<Integer, Double> info = new HashMap<Integer, Double>();
            for (INBT entryInside : entryList) {
                CompoundNBT inside = (CompoundNBT)entryInside;
                int frequency = inside.func_74762_e("frequency");
                double joules = inside.func_74769_h("joules");
                info.put(frequency, joules);
            }
            this.powermapping.put(id, info);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT source) {
        ListNBT list = new ListNBT();
        source.func_218657_a("list", (INBT)list);
        for (Map.Entry<UUID, HashMap<Integer, Double>> en : this.powermapping.entrySet()) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_186854_a("uuid", en.getKey());
            ListNBT entrylist = new ListNBT();
            compound.func_218657_a("entrylist", (INBT)entrylist);
            for (Map.Entry<Integer, Double> entryInside : en.getValue().entrySet()) {
                CompoundNBT inside = new CompoundNBT();
                inside.func_74768_a("frequency", entryInside.getKey().intValue());
                inside.func_74780_a("joules", entryInside.getValue().doubleValue());
                entrylist.add((Object)inside);
            }
            list.add((Object)compound);
        }
        return source;
    }

    public static QuantumCapacitorData get(World world) {
        if (world instanceof ServerWorld) {
            DimensionSavedDataManager storage = ((ServerWorld)world).func_217481_x();
            QuantumCapacitorData instance = (QuantumCapacitorData)storage.func_215752_a(QuantumCapacitorData::new, DATANAME);
            if (instance == null) {
                instance = new QuantumCapacitorData();
                storage.func_215757_a((WorldSavedData)instance);
            }
            return instance;
        }
        return null;
    }

    public boolean func_76188_b() {
        return true;
    }

    public double getJoules(UUID uuid, int frequency) {
        if (this.powermapping.containsKey(uuid)) {
            HashMap<Integer, Double> value = this.powermapping.get(uuid);
            if (value.containsKey(frequency)) {
                return value.get(frequency);
            }
            value.put(frequency, 0.0);
            return 0.0;
        }
        this.powermapping.put(uuid, new HashMap());
        this.powermapping.get(uuid).put(frequency, 0.0);
        return 0.0;
    }

    public void setJoules(UUID uuid, int frequency, double value) {
        this.getJoules(uuid, frequency);
        this.powermapping.get(uuid).put(frequency, value);
    }
}

