/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatibility.jei;

import electrodynamics.compatibility.jei.recipecategories.utils.psuedorecipes.types.PsuedoItem2ItemRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import nuclearscience.NuclearScience;
import nuclearscience.client.screen.ScreenChemicalExtractor;
import nuclearscience.client.screen.ScreenFissionReactorCore;
import nuclearscience.client.screen.ScreenGasCentrifuge;
import nuclearscience.client.screen.ScreenMSRFuelPreProcessor;
import nuclearscience.client.screen.ScreenNuclearBoiler;
import nuclearscience.client.screen.ScreenParticleInjector;
import nuclearscience.client.screen.ScreenRadioactiveProcessor;
import nuclearscience.compatibility.jei.recipecategories.fluiditem2fluid.specificmachines.NuclearBoilerRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.fluiditem2item.specificmachines.ChemicalExtractorRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.fluiditem2item.specificmachines.MSRProcessorRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.fluiditem2item.specificmachines.RadioactiveProcessorRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.item2item.FissionReactorRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.item2item.FuelReprocessorRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.psuedo.specificmachines.GasCentrifugeRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.psuedo.specificmachines.ParticleAcceleratorAntiMatterRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.psuedo.specificmachines.ParticleAcceleratorDarkMatterRecipeCategory;
import nuclearscience.compatibility.jei.utils.psuedorecipes.NuclearSciencePsuedoRecipes;
import nuclearscience.compatibility.jei.utils.psuedorecipes.PsuedoGasCentrifugeRecipe;
import nuclearscience.registers.NuclearScienceRecipies;

@JeiPlugin
public class NuclearSciencePlugin
implements IModPlugin {
    public static final ResourceLocation ID = NuclearScience.rl("jei");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)GasCentrifugeRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{GasCentrifugeRecipeCategory.RECIPE_TYPE.getUid()});
        registration.addRecipeCatalyst((Object)NuclearBoilerRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{NuclearBoilerRecipeCategory.RECIPE_TYPE.getUid()});
        registration.addRecipeCatalyst((Object)ChemicalExtractorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{ChemicalExtractorRecipeCategory.RECIPE_TYPE.getUid()});
        registration.addRecipeCatalyst((Object)FissionReactorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{FissionReactorRecipeCategory.RECIPE_TYPE.getUid()});
        registration.addRecipeCatalyst((Object)ParticleAcceleratorAntiMatterRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{ParticleAcceleratorAntiMatterRecipeCategory.RECIPE_TYPE.getUid()});
        registration.addRecipeCatalyst((Object)ParticleAcceleratorDarkMatterRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{ParticleAcceleratorDarkMatterRecipeCategory.RECIPE_TYPE.getUid()});
        registration.addRecipeCatalyst((Object)FuelReprocessorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{FuelReprocessorRecipeCategory.RECIPE_TYPE.getUid()});
        registration.addRecipeCatalyst((Object)RadioactiveProcessorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{RadioactiveProcessorRecipeCategory.RECIPE_TYPE.getUid()});
        registration.addRecipeCatalyst((Object)MSRProcessorRecipeCategory.INPUT_MACHINE, new ResourceLocation[]{MSRProcessorRecipeCategory.RECIPE_TYPE.getUid()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        NuclearSciencePsuedoRecipes.addNuclearScienceRecipes();
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = Objects.requireNonNull(mc.field_71441_e);
        RecipeManager recipeManager = world.func_199532_z();
        ArrayList<PsuedoGasCentrifugeRecipe> gasCentrifugeRecipes = new ArrayList<PsuedoGasCentrifugeRecipe>(NuclearSciencePsuedoRecipes.GAS_CENTRIFUGE_RECIPES);
        registration.addRecipes(gasCentrifugeRecipes, GasCentrifugeRecipeCategory.RECIPE_TYPE.getUid());
        List nuclearBoilerRecipes = recipeManager.func_241447_a_(NuclearScienceRecipies.NUCLEAR_BOILER_TYPE);
        registration.addRecipes((Collection)nuclearBoilerRecipes, NuclearBoilerRecipeCategory.RECIPE_TYPE.getUid());
        List chemicalExtractorRecipes = recipeManager.func_241447_a_(NuclearScienceRecipies.CHEMICAL_EXTRACTOR_TYPE);
        registration.addRecipes((Collection)chemicalExtractorRecipes, ChemicalExtractorRecipeCategory.RECIPE_TYPE.getUid());
        List fissionReactorRecipes = recipeManager.func_241447_a_(NuclearScienceRecipies.FISSION_REACTOR_TYPE);
        registration.addRecipes((Collection)fissionReactorRecipes, FissionReactorRecipeCategory.RECIPE_TYPE.getUid());
        ArrayList<PsuedoItem2ItemRecipe> antiMatterRecipes = new ArrayList<PsuedoItem2ItemRecipe>(NuclearSciencePsuedoRecipes.ANTI_MATTER_RECIPES);
        registration.addRecipes(antiMatterRecipes, ParticleAcceleratorAntiMatterRecipeCategory.RECIPE_TYPE.getUid());
        ArrayList<PsuedoItem2ItemRecipe> darkMatterRecipes = new ArrayList<PsuedoItem2ItemRecipe>(NuclearSciencePsuedoRecipes.DARK_MATTER_RECIPES);
        registration.addRecipes(darkMatterRecipes, ParticleAcceleratorDarkMatterRecipeCategory.RECIPE_TYPE.getUid());
        List fuelReprocessorRecipes = recipeManager.func_241447_a_(NuclearScienceRecipies.FUEL_REPROCESSOR_TYPE);
        registration.addRecipes((Collection)fuelReprocessorRecipes, FuelReprocessorRecipeCategory.RECIPE_TYPE.getUid());
        List radioactiveProcessorRecipes = recipeManager.func_241447_a_(NuclearScienceRecipies.RADIOACTIVE_PROCESSOR_TYPE);
        registration.addRecipes((Collection)radioactiveProcessorRecipes, RadioactiveProcessorRecipeCategory.RECIPE_TYPE.getUid());
        List msrProcessorRecipes = recipeManager.func_241447_a_(NuclearScienceRecipies.MSR_FUEL_PREPROCESSOR_TYPE);
        registration.addRecipes((Collection)msrProcessorRecipes, MSRProcessorRecipeCategory.RECIPE_TYPE.getUid());
        NuclearSciencePlugin.nuclearScienceInfoTabs(registration);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new GasCentrifugeRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new NuclearBoilerRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ChemicalExtractorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FissionReactorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParticleAcceleratorAntiMatterRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParticleAcceleratorDarkMatterRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FuelReprocessorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RadioactiveProcessorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MSRProcessorRecipeCategory(helper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ScreenNuclearBoiler.class, 97, 31, 22, 15, new ResourceLocation[]{NuclearBoilerRecipeCategory.RECIPE_TYPE.getUid()});
        registry.addRecipeClickArea(ScreenRadioactiveProcessor.class, 97, 31, 22, 15, new ResourceLocation[]{RadioactiveProcessorRecipeCategory.RECIPE_TYPE.getUid()});
        registry.addRecipeClickArea(ScreenChemicalExtractor.class, 97, 31, 22, 15, new ResourceLocation[]{ChemicalExtractorRecipeCategory.RECIPE_TYPE.getUid()});
        registry.addRecipeClickArea(ScreenGasCentrifuge.class, 105, 13, 20, 54, new ResourceLocation[]{GasCentrifugeRecipeCategory.RECIPE_TYPE.getUid()});
        registry.addRecipeClickArea(ScreenFissionReactorCore.class, 117, 53, 14, 13, new ResourceLocation[]{FissionReactorRecipeCategory.RECIPE_TYPE.getUid()});
        registry.addRecipeClickArea(ScreenParticleInjector.class, 102, 43, 28, 14, new ResourceLocation[]{ParticleAcceleratorAntiMatterRecipeCategory.RECIPE_TYPE.getUid(), ParticleAcceleratorDarkMatterRecipeCategory.RECIPE_TYPE.getUid()});
        registry.addRecipeClickArea(ScreenMSRFuelPreProcessor.class, 98, 40, 16, 16, new ResourceLocation[]{MSRProcessorRecipeCategory.RECIPE_TYPE.getUid()});
    }

    private static void nuclearScienceInfoTabs(IRecipeRegistration registration) {
    }
}

