/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.prefab.screen.component.quantumtunnel;

import com.mojang.blaze3d.matrix.MatrixStack;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import nuclearscience.common.inventory.container.ContainerQuantumTunnel;
import nuclearscience.common.tile.TileQuantumTunnel;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentInventoryIO;
import voltaic.prefab.utilities.math.Color;

public class ButtonIO
extends ScreenComponentButton<ButtonIO> {
    public static final int DRAWING_AREA_SIZE = 24;
    private static final Color SLOT_GRAY = new Color(150, 150, 150, 255);
    public static final Color INPUT = new Color(167, 223, 248, 255);
    public static final Color OUTPUT = new Color(255, 120, 46, 255);
    private final Direction side;

    public ButtonIO(int x, int y, Direction side) {
        super((ITexture)ScreenComponentInventoryIO.InventoryIOTextures.DEFAULT, x, y);
        this.onTooltip((poseStack, component, xAxis, yAxis) -> {
            ArrayList<IReorderingProcessor> tooltips = new ArrayList<IReorderingProcessor>();
            tooltips.add(this.getLabelFromDir().func_241878_f());
            tooltips.add(this.getModeForSide().func_241878_f());
            this.gui.displayTooltips(poseStack, tooltips, xAxis, yAxis);
        });
        this.setOnPress(button -> {
            GenericScreen screen = (GenericScreen)this.gui;
            ContainerQuantumTunnel container = (ContainerQuantumTunnel)screen.func_212873_a_();
            TileQuantumTunnel tile = (TileQuantumTunnel)container.getSafeHost();
            if (tile == null) {
                return;
            }
            boolean in = tile.readInputDirections().contains(side);
            boolean out = tile.readOutputDirections().contains(side);
            if (in) {
                tile.removeInputDirection(side);
                tile.writeOutputDirection(side);
            } else if (out) {
                tile.removeInputDirection(side);
                tile.removeOutputDirection(side);
            } else {
                tile.writeInputDirection(side);
            }
        });
        this.side = side;
    }

    public void renderBackground(MatrixStack poseStack, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(poseStack, xAxis, yAxis, guiWidth, guiHeight);
        GenericScreen screen = (GenericScreen)this.gui;
        ContainerQuantumTunnel container = (ContainerQuantumTunnel)screen.func_212873_a_();
        TileQuantumTunnel tile = (TileQuantumTunnel)container.getSafeHost();
        if (tile == null) {
            return;
        }
        Color ioColor = tile.readInputDirections().contains(this.side) ? INPUT : (tile.readOutputDirections().contains(this.side) ? OUTPUT : SLOT_GRAY);
        ButtonIO.func_238467_a_((MatrixStack)poseStack, (int)(this.field_230690_l_ + guiWidth + 1), (int)(this.field_230691_m_ + guiHeight + 1), (int)(this.field_230690_l_ + guiWidth + 1 + 24), (int)(this.field_230691_m_ + guiHeight + 1 + 24), (int)ioColor.color());
    }

    private IFormattableTextComponent getLabelFromDir() {
        IFormattableTextComponent component = null;
        switch (this.side) {
            default: {
                component = ElectroTextUtils.tooltip((String)"inventoryio.bottom", (Object[])new Object[0]);
                break;
            }
            case UP: {
                component = ElectroTextUtils.tooltip((String)"inventoryio.top", (Object[])new Object[0]);
                break;
            }
            case EAST: {
                component = ElectroTextUtils.tooltip((String)"inventoryio.left", (Object[])new Object[0]);
                break;
            }
            case WEST: {
                component = ElectroTextUtils.tooltip((String)"inventoryio.right", (Object[])new Object[0]);
                break;
            }
            case NORTH: {
                component = ElectroTextUtils.tooltip((String)"inventoryio.front", (Object[])new Object[0]);
                break;
            }
            case SOUTH: {
                component = ElectroTextUtils.tooltip((String)"inventoryio.back", (Object[])new Object[0]);
            }
        }
        return component;
    }

    private IFormattableTextComponent getModeForSide() {
        GenericScreen screen = (GenericScreen)this.gui;
        ContainerQuantumTunnel container = (ContainerQuantumTunnel)screen.func_212873_a_();
        TileQuantumTunnel tile = (TileQuantumTunnel)container.getSafeHost();
        if (tile == null) {
            return new StringTextComponent("");
        }
        boolean in = tile.readInputDirections().contains(this.side);
        boolean out = tile.readOutputDirections().contains(this.side);
        if (in) {
            return NuclearTextUtils.tooltip("quantumtunnel.input", new Object[0]);
        }
        if (out) {
            return NuclearTextUtils.tooltip("quantumtunnel.output", new Object[0]);
        }
        return NuclearTextUtils.tooltip("quantumtunnel.none", new Object[0]);
    }
}

