/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.prefab.screen.component.quantumtunnel;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.client.screen.ScreenQuantumTunnel;
import nuclearscience.common.inventory.container.ContainerQuantumTunnel;
import nuclearscience.common.packet.NetworkHandler;
import nuclearscience.common.packet.type.server.PacketEditFrequency;
import nuclearscience.common.tile.TileQuantumTunnel;
import nuclearscience.prefab.utils.NuclearTextUtils;
import org.apache.commons.lang3.StringUtils;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class WrapperEditFrequency {
    private ScreenComponentSimpleLabel titleLabel;
    private ScreenComponentSimpleLabel nameLabel;
    public ScreenComponentEditBox nameEditBox;
    private ScreenComponentButton<?> saveButton;
    private ScreenComponentButton<?> cancelButton;
    private TunnelFrequency currFrequency;

    public WrapperEditFrequency(ScreenQuantumTunnel screen, int x, int y) {
        this.titleLabel = new ScreenComponentSimpleLabel(x + 15, y + 20, 10, Color.TEXT_GRAY, (ITextComponent)NuclearTextUtils.gui("quantumtunnel.editfrequency", new Object[0]));
        screen.addComponent((AbstractScreenComponent)this.titleLabel);
        this.nameLabel = new ScreenComponentSimpleLabel(x + 15, y + 40, 10, Color.TEXT_GRAY, (ITextComponent)NuclearTextUtils.gui("quantumtunnel.name", new Object[0]));
        screen.addComponent((AbstractScreenComponent)this.nameLabel);
        this.nameEditBox = new ScreenComponentEditBox(x + 15, y + 50, 120, 15, screen.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(50);
        screen.addEditBox(this.nameEditBox);
        this.saveButton = new ScreenComponentButton(x + 13, y + 70, 70, 20).setOnPress(button -> {
            if (this.nameEditBox.getValue().isEmpty() || StringUtils.isBlank((CharSequence)this.nameEditBox.getValue()) || this.currFrequency == null) {
                return;
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)screen.func_212873_a_()).getSafeHost();
            if (tile == null) {
                return;
            }
            String name = this.nameEditBox.getValue();
            if (!this.currFrequency.getName().equals(name) && this.currFrequency.getCreatorId().equals(player.func_110124_au())) {
                this.currFrequency.setName(name);
                if (((TunnelFrequency)tile.frequency.getValue()).equals(this.currFrequency)) {
                    tile.frequency.setValue((Object)this.currFrequency);
                    tile.frequency.forceDirtyForManager();
                }
                NetworkHandler.CHANNEL.sendToServer((Object)new PacketEditFrequency(player.func_110124_au(), this.currFrequency));
            }
            this.updateVisibility(false);
            this.nameEditBox.setValue("");
            screen.frequencyWrapper.updateVisibility(true);
        }).setLabel(NuclearTextUtils.gui("quantumtunnel.save", new Object[0]));
        screen.addComponent((AbstractScreenComponent)this.saveButton);
        this.cancelButton = new ScreenComponentButton(x + 93, y + 70, 70, 20).setOnPress(button -> {
            screen.frequencyWrapper.updateVisibility(true);
            this.updateVisibility(false);
            this.nameEditBox.setValue("");
            screen.slider.setVisible(true);
        }).setLabel(NuclearTextUtils.gui("quantumtunnel.cancel", new Object[0]));
        screen.addComponent((AbstractScreenComponent)this.cancelButton);
        this.updateVisibility(false);
    }

    public void updateVisibility(boolean show) {
        this.titleLabel.setVisible(show);
        this.nameLabel.setVisible(show);
        this.nameEditBox.setVisible(show);
        this.nameEditBox.setActive(show);
        this.saveButton.setVisible(show);
        this.cancelButton.setVisible(show);
    }

    public void updateFrequency(TunnelFrequency frequency) {
        this.currFrequency = frequency;
        this.nameEditBox.setValue(frequency.getName());
    }
}

