/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.prefab.screen.component.quantumtunnel;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.StringTextComponent;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.client.screen.ScreenQuantumTunnel;
import nuclearscience.common.inventory.container.ContainerQuantumTunnel;
import nuclearscience.common.packet.NetworkHandler;
import nuclearscience.common.packet.type.server.PacketDeleteFrequency;
import nuclearscience.common.tile.TileQuantumTunnel;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.screen.component.quantumtunnel.ButtonTunnelFrequency;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentFillArea;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class WrapperQuantumTunnelFrequencies {
    private final ScreenQuantumTunnel screen;
    private ScreenComponentFillArea box;
    private ScreenComponentSimpleLabel frequencyLabel;
    private ScreenComponentButton<?> enable;
    private ScreenComponentButton<?> disable;
    private ButtonTunnelFrequency[] frequencyButtons = new ButtonTunnelFrequency[5];
    private ScreenComponentButton[] editButtons = new ScreenComponentButton[5];
    private ScreenComponentButton[] deleteButtons = new ScreenComponentButton[5];
    private ScreenComponentButton<?> publicSelector;
    private ScreenComponentButton<?> privateSelector;
    private int topRowIndex = 0;
    private int lastRowCount = 0;
    private boolean isPrivate = true;
    private TunnelFrequency selectedFrequency = null;
    private static final int BUTTON_COUNT = 5;

    public WrapperQuantumTunnelFrequencies(ScreenQuantumTunnel screen, int x, int y) {
        int index;
        int i;
        this.screen = screen;
        this.box = new ScreenComponentFillArea(x + 5, y + 24, 120, 10, new Color(112, 112, 112, 255), new Color(28, 28, 28, 255));
        this.frequencyLabel = new ScreenComponentSimpleLabel(x + 6, y + 25, 10, Color.WHITE, () -> {
            TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)screen.func_212873_a_()).getSafeHost();
            Object frequencyName = this.selectedFrequency != null ? new StringTextComponent(this.selectedFrequency.getName()) : (tile == null || ((TunnelFrequency)tile.frequency.getValue()).equals(TunnelFrequency.NO_FREQUENCY) ? NuclearTextUtils.gui("quantumtunnel.none", new Object[0]) : new StringTextComponent(((TunnelFrequency)tile.frequency.getValue()).getName()));
            return frequencyName;
        });
        this.enable = (ScreenComponentButton)new ScreenComponentButton(x + 127, y + 19, 20, 20).setOnPress(but -> {
            TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)screen.func_212873_a_()).getSafeHost();
            if (tile == null || this.selectedFrequency == null || ((TunnelFrequency)tile.frequency.getValue()).equals(this.selectedFrequency)) {
                return;
            }
            tile.frequency.setValue((Object)this.selectedFrequency);
        }).onTooltip((poseStack, button, xAxis, yAxis) -> screen.displayTooltip(poseStack, NuclearTextUtils.gui("quantumtunnel.enable", new Object[0]).func_241878_f(), xAxis, yAxis)).setIcon((ITexture)NuclearIconTypes.ENABLE);
        this.disable = (ScreenComponentButton)new ScreenComponentButton(x + 150, y + 19, 20, 20).setOnPress(but -> {
            TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)screen.func_212873_a_()).getSafeHost();
            if (tile == null) {
                return;
            }
            tile.frequency.setValue((Object)TunnelFrequency.NO_FREQUENCY);
        }).onTooltip((poseStack, button, xAxis, yAxis) -> screen.displayTooltip(poseStack, NuclearTextUtils.gui("quantumtunnel.disable", new Object[0]).func_241878_f(), xAxis, yAxis)).setIcon((ITexture)NuclearIconTypes.DISABLE);
        this.publicSelector = new ScreenComponentButton(x + 16, y + 44, 70, 15).setOnPress(but -> {
            ScreenComponentButton button = but;
            button.isPressed = true;
            this.privateSelector.isPressed = false;
            this.isPrivate = false;
        }).setLabel(NuclearTextUtils.gui("quantumtunnel.public", new Object[0]));
        this.privateSelector = new ScreenComponentButton(x + 70 + 16 + 5, y + 44, 70, 15).setOnPress(but -> {
            ScreenComponentButton button = but;
            button.isPressed = true;
            this.publicSelector.isPressed = false;
            this.isPrivate = true;
        }).setLabel(NuclearTextUtils.gui("quantumtunnel.private", new Object[0]));
        int butOffX = 19;
        int butOffY = 64;
        for (i = 0; i < 5; ++i) {
            this.frequencyButtons[i] = (ButtonTunnelFrequency)new ButtonTunnelFrequency(x + butOffX, y + butOffY + 25 * i, 110, 25).setOnPress(but -> {
                ButtonTunnelFrequency button = (ButtonTunnelFrequency)but;
                TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)screen.func_212873_a_()).getSafeHost();
                if (tile == null || button.getFrequency() == null) {
                    this.selectedFrequency = null;
                    return;
                }
                this.selectedFrequency = button.getFrequency();
            });
        }
        for (i = 0; i < 5; ++i) {
            index = i;
            this.editButtons[i] = (ScreenComponentButton)new ScreenComponentButton(x + butOffX + 111, y + 2 + butOffY + 25 * i, 20, 20).setOnPress(but -> {
                ButtonTunnelFrequency tunnel = this.frequencyButtons[index];
                if (tunnel.getFrequency() == null) {
                    return;
                }
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player == null || !tunnel.getFrequency().getCreatorId().equals(player.func_110124_au())) {
                    return;
                }
                screen.editFrequencyWrapper.updateFrequency(tunnel.getFrequency());
                screen.editFrequencyWrapper.updateVisibility(true);
                screen.slider.setVisible(false);
                this.updateVisibility(false);
            }).onTooltip((poseStack, button, xAxis, yAxis) -> screen.displayTooltip(poseStack, NuclearTextUtils.gui("quantumtunnel.edit", new Object[0]).func_241878_f(), xAxis, yAxis)).setIcon((ITexture)NuclearIconTypes.PENCIL);
        }
        for (i = 0; i < 5; ++i) {
            index = i;
            this.deleteButtons[i] = (ScreenComponentButton)new ScreenComponentButton(x + butOffX + 132, y + 2 + butOffY + 25 * i, 20, 20).setOnPress(but -> {
                ButtonTunnelFrequency tunnel = this.frequencyButtons[index];
                TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)screen.func_212873_a_()).getSafeHost();
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player == null || tunnel.getFrequency() == null || tile == null) {
                    return;
                }
                TunnelFrequency frequency = tunnel.getFrequency();
                if (this.selectedFrequency != null && this.selectedFrequency.equals(frequency) && this.selectedFrequency.getCreatorId().equals(player.func_110124_au())) {
                    this.selectedFrequency = null;
                }
                if (((TunnelFrequency)tile.frequency.getValue()).equals(frequency)) {
                    tile.frequency.setValue((Object)TunnelFrequency.NO_FREQUENCY);
                }
                NetworkHandler.CHANNEL.sendToServer((Object)new PacketDeleteFrequency(player.func_110124_au(), frequency));
            }).onTooltip((poseStack, button, xAxis, yAxis) -> screen.displayTooltip(poseStack, NuclearTextUtils.gui("quantumtunnel.delete", new Object[0]).func_241878_f(), xAxis, yAxis)).setIcon((ITexture)NuclearIconTypes.DELETE);
        }
        screen.addComponent((AbstractScreenComponent)this.box);
        screen.addComponent((AbstractScreenComponent)this.frequencyLabel);
        screen.addComponent((AbstractScreenComponent)this.enable);
        screen.addComponent((AbstractScreenComponent)this.disable);
        screen.addComponent((AbstractScreenComponent)this.publicSelector);
        screen.addComponent((AbstractScreenComponent)this.privateSelector);
        for (i = 0; i < 5; ++i) {
            screen.addComponent((AbstractScreenComponent)this.frequencyButtons[i]);
        }
        for (i = 0; i < 5; ++i) {
            screen.addComponent((AbstractScreenComponent)this.editButtons[i]);
        }
        for (i = 0; i < 5; ++i) {
            screen.addComponent((AbstractScreenComponent)this.deleteButtons[i]);
        }
        this.privateSelector.isPressed = true;
    }

    public void tick() {
        TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)this.screen.func_212873_a_()).getSafeHost();
        if (tile == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ArrayList frequencies = new ArrayList();
        if (this.isPrivate) {
            frequencies.addAll(tile.clientFrequencies.get(player.func_110124_au()));
        } else {
            frequencies.addAll(tile.clientFrequencies.get(TunnelFrequency.PUBLIC_ID));
        }
        this.lastRowCount = frequencies.size();
        for (int i = 0; i < 5; ++i) {
            ButtonTunnelFrequency button = this.frequencyButtons[i];
            int index = this.topRowIndex + i;
            if (index < frequencies.size()) {
                button.setFrequency((TunnelFrequency)frequencies.get(index));
                continue;
            }
            button.setFrequency(null);
        }
        ScreenComponentVerticalSlider slider = this.screen.slider;
        if (this.lastRowCount > 5) {
            slider.updateActive(true);
            if (!slider.isSliderHeld()) {
                int moveRoom = this.screen.slider.func_238483_d_() - 15 - 2;
                double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                slider.setSliderYOffset((int)((double)moveRoom * moved));
            }
        } else {
            slider.updateActive(false);
            slider.setSliderYOffset(0);
            this.topRowIndex = 0;
        }
    }

    public void handleMouseScroll(int dir) {
        if (Screen.func_231172_r_()) {
            dir *= 4;
        }
        int lastRowIndex = this.lastRowCount - 1;
        if (this.lastRowCount > 5) {
            if (this.topRowIndex >= this.lastRowCount) {
                this.topRowIndex = lastRowIndex - 4;
            }
            this.topRowIndex = MathHelper.func_76125_a((int)(this.topRowIndex += dir), (int)0, (int)(lastRowIndex - 4));
        } else {
            this.topRowIndex = 0;
        }
    }

    public Consumer<Integer> getSliderClickedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.slider;
            if (slider.isSliderActive()) {
                int sliderY = slider.field_230691_m_;
                int sliderHeight = slider.func_238483_d_();
                int mouseHeight = mouseY - sliderY;
                if (mouseHeight >= sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else if (mouseHeight <= 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else {
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                    int moveRoom = slider.func_238483_d_() - 15 - 2;
                    double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                    slider.setSliderYOffset((int)((double)moveRoom * moved));
                }
            }
        };
    }

    public Consumer<Integer> getSliderDraggedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.slider;
            if (slider.isSliderActive()) {
                int sliderY = slider.field_230691_m_;
                int sliderHeight = slider.func_238483_d_();
                if (mouseY <= sliderY + 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else if (mouseY >= sliderY + sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else {
                    int mouseHeight = mouseY - sliderY;
                    slider.setSliderYOffset(mouseHeight);
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                }
            }
        };
    }

    public void updateVisibility(boolean show) {
        this.box.setVisible(show);
        this.frequencyLabel.setVisible(show);
        this.enable.setVisible(show);
        this.disable.setVisible(show);
        for (ButtonTunnelFrequency buttonTunnelFrequency : this.frequencyButtons) {
            buttonTunnelFrequency.setVisible(show);
        }
        for (ButtonTunnelFrequency buttonTunnelFrequency : this.editButtons) {
            buttonTunnelFrequency.setVisible(show);
        }
        for (ButtonTunnelFrequency buttonTunnelFrequency : this.deleteButtons) {
            buttonTunnelFrequency.setVisible(show);
        }
        this.publicSelector.setVisible(show);
        this.privateSelector.setVisible(show);
    }
}

