/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.registers;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import nuclearscience.common.block.BlockElectromagneticBooster;
import nuclearscience.common.block.BlockElectromagneticDiode;
import nuclearscience.common.block.BlockElectromagneticGateway;
import nuclearscience.common.block.BlockElectromagneticSwitch;
import nuclearscience.common.block.BlockIrradiated;
import nuclearscience.common.block.BlockMeltedReactor;
import nuclearscience.common.block.BlockPlasma;
import nuclearscience.common.block.BlockRadioactiveAir;
import nuclearscience.common.block.BlockTurbine;
import nuclearscience.common.block.connect.BlockMoltenSaltPipe;
import nuclearscience.common.block.connect.BlockReactorLogisticsCable;
import nuclearscience.common.block.subtype.SubtypeElectromagent;
import nuclearscience.common.block.subtype.SubtypeIrradiatedBlock;
import nuclearscience.common.block.subtype.SubtypeMoltenSaltPipe;
import nuclearscience.common.block.subtype.SubtypeNuclearMachine;
import nuclearscience.common.block.subtype.SubtypeRadiationShielding;
import nuclearscience.common.block.subtype.SubtypeReactorLogisticsCable;
import nuclearscience.common.tile.TileQuantumTunnel;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import voltaic.api.registration.BulkRegistryObject;
import voltaic.api.tile.IMachine;
import voltaic.common.block.BlockCustomGlass;
import voltaic.common.block.BlockMachine;
import voltaic.prefab.utilities.math.Color;

public class NuclearScienceBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"nuclearscience");
    public static final BulkRegistryObject<Block, SubtypeRadiationShielding> BLOCKS_RADIATION_SHIELDING = new BulkRegistryObject((Object[])SubtypeRadiationShielding.values(), subtype -> BLOCKS.register(subtype.tag(), () -> {
        if (subtype == SubtypeRadiationShielding.door) {
            return new DoorBlock(subtype.properties);
        }
        if (subtype == SubtypeRadiationShielding.trapdoor) {
            return new TrapDoorBlock(subtype.properties);
        }
        if (subtype == SubtypeRadiationShielding.glass) {
            return new BlockCustomGlass(5.0f, 3.0f);
        }
        return new Block(subtype.properties);
    }));
    public static final RegistryObject<BlockTurbine> BLOCK_TURBINE = BLOCKS.register("turbine", BlockTurbine::new);
    public static final BulkRegistryObject<BlockMachine, SubtypeNuclearMachine> BLOCKS_NUCLEARMACHINE = new BulkRegistryObject((Object[])SubtypeNuclearMachine.values(), subtype -> BLOCKS.register(subtype.tag(), () -> {
        if (subtype == SubtypeNuclearMachine.chunkloader) {
            return new BlockMachine((IMachine)subtype){

                public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
                    return 15;
                }
            };
        }
        if (subtype == SubtypeNuclearMachine.fissionreactorcore) {
            return new BlockMachine((IMachine)subtype){

                public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
                    TileEntity blockentity = world.func_175625_s(pos);
                    if (blockentity instanceof TileFissionReactorCore) {
                        TileFissionReactorCore core = (TileFissionReactorCore)blockentity;
                        return (int)Math.max(0.0, Math.min((Double)core.temperature.getValue() / 5611.0 * 15.0, 15.0));
                    }
                    return super.getLightValue(state, world, pos);
                }
            };
        }
        return new BlockMachine((IMachine)subtype);
    }));
    public static final BulkRegistryObject<Block, SubtypeElectromagent> BLOCKS_ELECTROMAGENT = new BulkRegistryObject((Object[])SubtypeElectromagent.values(), subtype -> BLOCKS.register(subtype.tag(), () -> {
        if (subtype == SubtypeElectromagent.electromagneticglass) {
            return new BlockCustomGlass(3.5f, 20.0f);
        }
        return new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150339_S).func_200948_a(3.5f, 20.0f).func_235861_h_());
    }));
    public static final RegistryObject<BlockElectromagneticBooster> BLOCK_ELECTORMAGNETICBOOSTER = BLOCKS.register("electromagneticbooster", BlockElectromagneticBooster::new);
    public static final RegistryObject<BlockElectromagneticSwitch> BLOCK_ELECTROMAGNETICSWITCH = BLOCKS.register("electromagneticswitch", BlockElectromagneticSwitch::new);
    public static final RegistryObject<BlockElectromagneticGateway> BLOCK_ELECTROMAGNETICGATEWAY = BLOCKS.register("electromagneticgateway", BlockElectromagneticGateway::new);
    public static final RegistryObject<BlockElectromagneticDiode> BLOCK_ELECTROMAGNETICDIODE = BLOCKS.register("electromagneticdiode", BlockElectromagneticDiode::new);
    public static final RegistryObject<BlockPlasma> BLOCK_PLASMA = BLOCKS.register("plasma", BlockPlasma::new);
    public static final BulkRegistryObject<BlockMoltenSaltPipe, SubtypeMoltenSaltPipe> BLOCKS_MOLTENSALTPIPE = new BulkRegistryObject((Object[])SubtypeMoltenSaltPipe.values(), subtype -> BLOCKS.register(subtype.tag(), () -> new BlockMoltenSaltPipe((SubtypeMoltenSaltPipe)((Object)subtype))));
    public static final BulkRegistryObject<BlockReactorLogisticsCable, SubtypeReactorLogisticsCable> BLOCKS_REACTORLOGISTICSCABLE = new BulkRegistryObject((Object[])SubtypeReactorLogisticsCable.values(), subtype -> BLOCKS.register(subtype.tag(), () -> new BlockReactorLogisticsCable((SubtypeReactorLogisticsCable)((Object)subtype))));
    public static final RegistryObject<BlockMeltedReactor> BLOCK_MELTEDREACTOR = BLOCKS.register("meltedreactor", BlockMeltedReactor::new);
    public static final RegistryObject<BlockRadioactiveAir> BLOCK_RADIOACTIVEAIR = BLOCKS.register("radioactiveair", BlockRadioactiveAir::new);
    public static final BulkRegistryObject<BlockIrradiated, SubtypeIrradiatedBlock> BLOCKS_IRRADIATED = new BulkRegistryObject((Object[])SubtypeIrradiatedBlock.values(), subtype -> BLOCKS.register(subtype.tag(), () -> new BlockIrradiated((SubtypeIrradiatedBlock)((Object)subtype))));

    private static Direction getDirFromIndex(int index) {
        if (index == 1) {
            return Direction.SOUTH.func_176735_f();
        }
        if (index == 2) {
            return Direction.NORTH.func_176735_f();
        }
        if (index == 3) {
            return Direction.EAST.func_176735_f();
        }
        if (index == 4) {
            return Direction.WEST.func_176735_f();
        }
        if (index == 5) {
            return Direction.UP;
        }
        if (index == 6) {
            return Direction.DOWN;
        }
        return Direction.UP;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="nuclearscience", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class ColorHandlerInternal {
        private static final Color NONE = new Color(114, 114, 114, 255);
        private static final Color INPUT = new Color(167, 223, 248, 255);
        private static final Color OUTPUT = new Color(255, 120, 46, 255);

        private ColorHandlerInternal() {
        }

        @SubscribeEvent
        public static void registerColoredBlocks(ColorHandlerEvent.Block event) {
            Block block = (Block)BLOCKS_NUCLEARMACHINE.getValue((Object)SubtypeNuclearMachine.quantumcapacitor);
            event.getBlockColors().func_186722_a((state, level, pos, tintIndex) -> {
                if (tintIndex >= 1) {
                    TileEntity tile = level.func_175625_s(pos);
                    if (tile instanceof TileQuantumTunnel) {
                        TileQuantumTunnel tunnel = (TileQuantumTunnel)tile;
                        Direction dir = NuclearScienceBlocks.getDirFromIndex(tintIndex);
                        if (tunnel.readInputDirections().contains(dir)) {
                            return INPUT.color();
                        }
                        if (tunnel.readOutputDirections().contains(dir)) {
                            return OUTPUT.color();
                        }
                        return NONE.color();
                    }
                    return NONE.color();
                }
                return Color.WHITE.color();
            }, new Block[]{block});
        }
    }
}

