/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.registers;

import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import nuclearscience.common.recipe.categories.fluiditem2fluid.NuclearBoilerRecipe;
import nuclearscience.common.recipe.categories.fluiditem2item.ChemicalExtractorRecipe;
import nuclearscience.common.recipe.categories.fluiditem2item.MSRFuelPreProcessorRecipe;
import nuclearscience.common.recipe.categories.fluiditem2item.RadioactiveProcessorRecipe;
import nuclearscience.common.recipe.categories.item2item.FissionReactorRecipe;
import nuclearscience.common.recipe.categories.item2item.FuelReprocessorRecipe;
import voltaic.common.recipe.VoltaicRecipeType;
import voltaic.common.recipe.categories.fluiditem2fluid.FluidItem2FluidRecipeSerializer;
import voltaic.common.recipe.categories.fluiditem2item.FluidItem2ItemRecipeSerializer;
import voltaic.common.recipe.categories.item2item.Item2ItemRecipeSerializer;

public class NuclearScienceRecipies {
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"nuclearscience");
    public static final IRecipeType<FissionReactorRecipe> FISSION_REACTOR_TYPE = NuclearScienceRecipies.registerType(FissionReactorRecipe.RECIPE_ID, new VoltaicRecipeType());
    public static final IRecipeType<FuelReprocessorRecipe> FUEL_REPROCESSOR_TYPE = NuclearScienceRecipies.registerType(FuelReprocessorRecipe.RECIPE_ID, new VoltaicRecipeType());
    public static final IRecipeType<NuclearBoilerRecipe> NUCLEAR_BOILER_TYPE = NuclearScienceRecipies.registerType(NuclearBoilerRecipe.RECIPE_ID, new VoltaicRecipeType());
    public static final IRecipeType<ChemicalExtractorRecipe> CHEMICAL_EXTRACTOR_TYPE = NuclearScienceRecipies.registerType(ChemicalExtractorRecipe.RECIPE_ID, new VoltaicRecipeType());
    public static final IRecipeType<RadioactiveProcessorRecipe> RADIOACTIVE_PROCESSOR_TYPE = NuclearScienceRecipies.registerType(RadioactiveProcessorRecipe.RECIPE_ID, new VoltaicRecipeType());
    public static final IRecipeType<MSRFuelPreProcessorRecipe> MSR_FUEL_PREPROCESSOR_TYPE = NuclearScienceRecipies.registerType(MSRFuelPreProcessorRecipe.RECIPE_ID, new VoltaicRecipeType());
    public static final RegistryObject<IRecipeSerializer<?>> FISSION_REACTOR_SERIALIZER = RECIPE_SERIALIZER.register("fission_reactor_recipe", () -> new Item2ItemRecipeSerializer(FissionReactorRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> FUEL_REPROCESSOR_SERIALIZER = RECIPE_SERIALIZER.register("fuel_reprocessor_recipe", () -> new Item2ItemRecipeSerializer(FuelReprocessorRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> NUCLEAR_BOILER_SERIALIZER = RECIPE_SERIALIZER.register("nuclear_boiler_recipe", () -> new FluidItem2FluidRecipeSerializer(NuclearBoilerRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> CHEMICAL_EXTRACTOR_SERIALIZER = RECIPE_SERIALIZER.register("chemical_extractor_recipe", () -> new FluidItem2ItemRecipeSerializer(ChemicalExtractorRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> RADIOACTIVE_PROCESSOR_SERIALIZER = RECIPE_SERIALIZER.register("radioactive_processor_recipe", () -> new FluidItem2ItemRecipeSerializer(RadioactiveProcessorRecipe::new));
    public static final RegistryObject<IRecipeSerializer<?>> MSR_FUEL_PREPROCESSOR_SERIALIZER = RECIPE_SERIALIZER.register("msrfuel_preprocessor_recipe", () -> new FluidItem2ItemRecipeSerializer(MSRFuelPreProcessorRecipe::new));

    private static <T extends IRecipeType<?>> T registerType(ResourceLocation recipeTypeId, VoltaicRecipeType<?> type) {
        return (T)((IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)recipeTypeId, type));
    }

    public static void init() {
    }
}

