/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.quantumtunnel;

import java.util.HashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.server.ServerLifecycleHooks;
import nuclearscience.api.quantumtunnel.ICapabilityTunnelMap;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.prefab.utils.NuclearCapabilityUtils;
import nuclearscience.registers.NuclearScienceCapabilities;
import voltaic.prefab.utilities.object.TransferPack;

public class FrequencyConnectionManager {
    private static final HashMap<TunnelFrequency, TunnelFrequencyBuffer> CLIENT_BUFFER = new HashMap();

    public static TransferPack getBufferedEnergy(TunnelFrequency frequency) {
        ServerLevel level = FrequencyConnectionManager.getOverworld();
        ICapabilityTunnelMap cap = (ICapabilityTunnelMap)level.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP);
        if (cap == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            return TransferPack.EMPTY;
        }
        return cap.getMap().getOrDefault(frequency, new TunnelFrequencyBuffer()).getBufferedEnergy();
    }

    public static TransferPack recieveEnergy(TunnelFrequency frequency, TransferPack recieve, boolean simulate) {
        ServerLevel level = FrequencyConnectionManager.getOverworld();
        ICapabilityTunnelMap cap = (ICapabilityTunnelMap)level.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP);
        if (cap == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            return TransferPack.EMPTY;
        }
        HashMap<TunnelFrequency, TunnelFrequencyBuffer> map = cap.getMap();
        if (!map.containsKey(frequency)) {
            map.put(frequency, new TunnelFrequencyBuffer());
        }
        return map.get(frequency).addEnergy(simulate, recieve);
    }

    public static TransferPack extractEnergy(TunnelFrequency frequency, TransferPack extract, boolean simulate) {
        ServerLevel level = FrequencyConnectionManager.getOverworld();
        ICapabilityTunnelMap cap = (ICapabilityTunnelMap)level.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP);
        if (cap == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            return TransferPack.EMPTY;
        }
        HashMap<TunnelFrequency, TunnelFrequencyBuffer> map = cap.getMap();
        if (!map.containsKey(frequency)) {
            map.put(frequency, new TunnelFrequencyBuffer());
        }
        return map.get(frequency).extractEnergy(simulate, extract);
    }

    public static FluidStack getBufferedFluid(TunnelFrequency frequency) {
        ServerLevel level = FrequencyConnectionManager.getOverworld();
        ICapabilityTunnelMap cap = (ICapabilityTunnelMap)level.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP);
        if (cap == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            return FluidStack.EMPTY;
        }
        HashMap<TunnelFrequency, TunnelFrequencyBuffer> map = cap.getMap();
        return map.getOrDefault(frequency, new TunnelFrequencyBuffer()).getBufferedFluid();
    }

    public static FluidStack recieveFluid(TunnelFrequency frequency, FluidStack recieve, IFluidHandler.FluidAction action) {
        ServerLevel level = FrequencyConnectionManager.getOverworld();
        ICapabilityTunnelMap cap = (ICapabilityTunnelMap)level.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP);
        if (cap == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            return FluidStack.EMPTY;
        }
        HashMap<TunnelFrequency, TunnelFrequencyBuffer> map = cap.getMap();
        if (!map.containsKey(frequency)) {
            map.put(frequency, new TunnelFrequencyBuffer());
        }
        return map.get(frequency).addFluid(action, recieve);
    }

    public static FluidStack extractFluid(TunnelFrequency frequency, FluidStack extract, IFluidHandler.FluidAction action) {
        ServerLevel level = FrequencyConnectionManager.getOverworld();
        ICapabilityTunnelMap cap = (ICapabilityTunnelMap)level.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP);
        if (cap == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            return FluidStack.EMPTY;
        }
        HashMap<TunnelFrequency, TunnelFrequencyBuffer> map = cap.getMap();
        if (!map.containsKey(frequency)) {
            map.put(frequency, new TunnelFrequencyBuffer());
        }
        return map.get(frequency).extractFluid(action, extract);
    }

    public static ItemStack getBufferedItem(TunnelFrequency frequency) {
        ServerLevel level = FrequencyConnectionManager.getOverworld();
        ICapabilityTunnelMap cap = (ICapabilityTunnelMap)level.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP);
        if (cap == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            return ItemStack.f_41583_;
        }
        HashMap<TunnelFrequency, TunnelFrequencyBuffer> map = cap.getMap();
        return map.getOrDefault(frequency, new TunnelFrequencyBuffer()).getBufferedItem();
    }

    public static ItemStack recieveItem(TunnelFrequency frequency, ItemStack recieve, boolean simulate) {
        ServerLevel level = FrequencyConnectionManager.getOverworld();
        ICapabilityTunnelMap cap = (ICapabilityTunnelMap)level.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP);
        if (cap == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            return ItemStack.f_41583_;
        }
        HashMap<TunnelFrequency, TunnelFrequencyBuffer> map = cap.getMap();
        if (!map.containsKey(frequency)) {
            map.put(frequency, new TunnelFrequencyBuffer());
        }
        return map.get(frequency).addItem(simulate, recieve);
    }

    public static ItemStack extractItem(TunnelFrequency frequency, ItemStack extract, boolean simulate) {
        ServerLevel level = FrequencyConnectionManager.getOverworld();
        ICapabilityTunnelMap cap = (ICapabilityTunnelMap)level.getCapability(NuclearScienceCapabilities.CAPABILITY_TUNNELMAP).orElse((Object)NuclearCapabilityUtils.EMPTY_TUNNELMAP);
        if (cap == NuclearCapabilityUtils.EMPTY_TUNNELMAP) {
            return ItemStack.f_41583_;
        }
        HashMap<TunnelFrequency, TunnelFrequencyBuffer> map = cap.getMap();
        if (!map.containsKey(frequency)) {
            map.put(frequency, new TunnelFrequencyBuffer());
        }
        return map.get(frequency).extractItem(simulate, extract);
    }

    public static TunnelFrequencyBuffer getClientBuffer(TunnelFrequency frequency) {
        return CLIENT_BUFFER.getOrDefault(frequency, TunnelFrequencyBuffer.EMPTY);
    }

    public static void setClientBuffer(HashMap<TunnelFrequency, TunnelFrequencyBuffer> map) {
        CLIENT_BUFFER.clear();
        CLIENT_BUFFER.putAll(map);
    }

    private static ServerLevel getOverworld() {
        return ServerLifecycleHooks.getCurrentServer().m_129783_();
    }
}

